package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.PoolARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTapePoolResponse(
    poolARN: Optional[PoolARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateTapePoolResponse = {
    import CreateTapePoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateTapePoolResponse
      .builder()
      .optionallyWith(
        poolARN.map(value => PoolARN.unwrap(value): java.lang.String)
      )(_.poolARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CreateTapePoolResponse.ReadOnly =
    zio.aws.storagegateway.model.CreateTapePoolResponse.wrap(buildAwsValue())
}
object CreateTapePoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateTapePoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CreateTapePoolResponse =
      zio.aws.storagegateway.model
        .CreateTapePoolResponse(poolARN.map(value => value))
    def poolARN: Optional[PoolARN]
    def getPoolARN: ZIO[Any, AwsError, PoolARN] =
      AwsError.unwrapOptionField("poolARN", poolARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateTapePoolResponse
  ) extends zio.aws.storagegateway.model.CreateTapePoolResponse.ReadOnly {
    override val poolARN: Optional[PoolARN] = zio.aws.core.internal
      .optionalFromNullable(impl.poolARN())
      .map(value => zio.aws.storagegateway.model.primitives.PoolARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateTapePoolResponse
  ): zio.aws.storagegateway.model.CreateTapePoolResponse.ReadOnly = new Wrapper(
    impl
  )
}
