package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  Ec2InstanceId,
  GatewayId,
  GatewayOperationalState,
  Ec2InstanceRegion,
  GatewayType,
  GatewayARN,
  HostEnvironmentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GatewayInfo(
    gatewayId: Optional[GatewayId] = Optional.Absent,
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    gatewayType: Optional[GatewayType] = Optional.Absent,
    gatewayOperationalState: Optional[GatewayOperationalState] =
      Optional.Absent,
    gatewayName: Optional[String] = Optional.Absent,
    ec2InstanceId: Optional[Ec2InstanceId] = Optional.Absent,
    ec2InstanceRegion: Optional[Ec2InstanceRegion] = Optional.Absent,
    hostEnvironment: Optional[zio.aws.storagegateway.model.HostEnvironment] =
      Optional.Absent,
    hostEnvironmentId: Optional[HostEnvironmentId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.GatewayInfo = {
    import GatewayInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.GatewayInfo
      .builder()
      .optionallyWith(
        gatewayId.map(value => GatewayId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        gatewayType.map(value => GatewayType.unwrap(value): java.lang.String)
      )(_.gatewayType)
      .optionallyWith(
        gatewayOperationalState.map(value =>
          GatewayOperationalState.unwrap(value): java.lang.String
        )
      )(_.gatewayOperationalState)
      .optionallyWith(gatewayName.map(value => value: java.lang.String))(
        _.gatewayName
      )
      .optionallyWith(
        ec2InstanceId.map(value =>
          Ec2InstanceId.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceId)
      .optionallyWith(
        ec2InstanceRegion.map(value =>
          Ec2InstanceRegion.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceRegion)
      .optionallyWith(hostEnvironment.map(value => value.unwrap))(
        _.hostEnvironment
      )
      .optionallyWith(
        hostEnvironmentId.map(value =>
          HostEnvironmentId.unwrap(value): java.lang.String
        )
      )(_.hostEnvironmentId)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.GatewayInfo.ReadOnly =
    zio.aws.storagegateway.model.GatewayInfo.wrap(buildAwsValue())
}
object GatewayInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.GatewayInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.GatewayInfo =
      zio.aws.storagegateway.model.GatewayInfo(
        gatewayId.map(value => value),
        gatewayARN.map(value => value),
        gatewayType.map(value => value),
        gatewayOperationalState.map(value => value),
        gatewayName.map(value => value),
        ec2InstanceId.map(value => value),
        ec2InstanceRegion.map(value => value),
        hostEnvironment.map(value => value),
        hostEnvironmentId.map(value => value)
      )
    def gatewayId: Optional[GatewayId]
    def gatewayARN: Optional[GatewayARN]
    def gatewayType: Optional[GatewayType]
    def gatewayOperationalState: Optional[GatewayOperationalState]
    def gatewayName: Optional[String]
    def ec2InstanceId: Optional[Ec2InstanceId]
    def ec2InstanceRegion: Optional[Ec2InstanceRegion]
    def hostEnvironment: Optional[zio.aws.storagegateway.model.HostEnvironment]
    def hostEnvironmentId: Optional[HostEnvironmentId]
    def getGatewayId: ZIO[Any, AwsError, GatewayId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getGatewayType: ZIO[Any, AwsError, GatewayType] =
      AwsError.unwrapOptionField("gatewayType", gatewayType)
    def getGatewayOperationalState
        : ZIO[Any, AwsError, GatewayOperationalState] = AwsError
      .unwrapOptionField("gatewayOperationalState", gatewayOperationalState)
    def getGatewayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayName", gatewayName)
    def getEc2InstanceId: ZIO[Any, AwsError, Ec2InstanceId] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getEc2InstanceRegion: ZIO[Any, AwsError, Ec2InstanceRegion] =
      AwsError.unwrapOptionField("ec2InstanceRegion", ec2InstanceRegion)
    def getHostEnvironment
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.HostEnvironment] =
      AwsError.unwrapOptionField("hostEnvironment", hostEnvironment)
    def getHostEnvironmentId: ZIO[Any, AwsError, HostEnvironmentId] =
      AwsError.unwrapOptionField("hostEnvironmentId", hostEnvironmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.GatewayInfo
  ) extends zio.aws.storagegateway.model.GatewayInfo.ReadOnly {
    override val gatewayId: Optional[GatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayId(value))
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val gatewayType: Optional[GatewayType] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayType())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayType(value))
    override val gatewayOperationalState: Optional[GatewayOperationalState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayOperationalState())
        .map(value =>
          zio.aws.storagegateway.model.primitives.GatewayOperationalState(value)
        )
    override val gatewayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayName())
      .map(value => value: String)
    override val ec2InstanceId: Optional[Ec2InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceId())
      .map(value =>
        zio.aws.storagegateway.model.primitives.Ec2InstanceId(value)
      )
    override val ec2InstanceRegion: Optional[Ec2InstanceRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceRegion())
        .map(value =>
          zio.aws.storagegateway.model.primitives.Ec2InstanceRegion(value)
        )
    override val hostEnvironment
        : Optional[zio.aws.storagegateway.model.HostEnvironment] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostEnvironment())
        .map(value => zio.aws.storagegateway.model.HostEnvironment.wrap(value))
    override val hostEnvironmentId: Optional[HostEnvironmentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostEnvironmentId())
        .map(value =>
          zio.aws.storagegateway.model.primitives.HostEnvironmentId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.GatewayInfo
  ): zio.aws.storagegateway.model.GatewayInfo.ReadOnly = new Wrapper(impl)
}
