package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.PoolARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTapePoolRequest(poolARN: PoolARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolRequest = {
    import DeleteTapePoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolRequest
      .builder()
      .poolARN(PoolARN.unwrap(poolARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DeleteTapePoolRequest.ReadOnly =
    zio.aws.storagegateway.model.DeleteTapePoolRequest.wrap(buildAwsValue())
}
object DeleteTapePoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteTapePoolRequest =
      zio.aws.storagegateway.model.DeleteTapePoolRequest(poolARN)
    def poolARN: PoolARN
    def getPoolARN: ZIO[Any, Nothing, PoolARN] = ZIO.succeed(poolARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolRequest
  ) extends zio.aws.storagegateway.model.DeleteTapePoolRequest.ReadOnly {
    override val poolARN: PoolARN =
      zio.aws.storagegateway.model.primitives.PoolARN(impl.poolARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolRequest
  ): zio.aws.storagegateway.model.DeleteTapePoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
