package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutomaticTapeCreationPolicyInfo(
    automaticTapeCreationRules: Optional[
      Iterable[zio.aws.storagegateway.model.AutomaticTapeCreationRule]
    ] = Optional.Absent,
    gatewayARN: Optional[GatewayARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationPolicyInfo = {
    import AutomaticTapeCreationPolicyInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationPolicyInfo
      .builder()
      .optionallyWith(
        automaticTapeCreationRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.automaticTapeCreationRules)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo.ReadOnly =
    zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo
      .wrap(buildAwsValue())
}
object AutomaticTapeCreationPolicyInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationPolicyInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo =
      zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo(
        automaticTapeCreationRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gatewayARN.map(value => value)
      )
    def automaticTapeCreationRules: Optional[
      List[zio.aws.storagegateway.model.AutomaticTapeCreationRule.ReadOnly]
    ]
    def gatewayARN: Optional[GatewayARN]
    def getAutomaticTapeCreationRules: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.AutomaticTapeCreationRule.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "automaticTapeCreationRules",
      automaticTapeCreationRules
    )
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationPolicyInfo
  ) extends zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo.ReadOnly {
    override val automaticTapeCreationRules: Optional[
      List[zio.aws.storagegateway.model.AutomaticTapeCreationRule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticTapeCreationRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.AutomaticTapeCreationRule.wrap(item)
        }.toList
      )
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationPolicyInfo
  ): zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo.ReadOnly =
    new Wrapper(impl)
}
