package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  StorageClass,
  UserListUser,
  KMSKey,
  AuditDestinationARN,
  FileShareName,
  FileShareId,
  FileShareARN,
  DNSHostName,
  RegionId,
  FileShareStatus,
  GatewayARN,
  LocationARN,
  Path,
  NotificationPolicy,
  Role,
  Authentication
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SMBFileShareInfo(
    fileShareARN: Optional[FileShareARN] = Optional.Absent,
    fileShareId: Optional[FileShareId] = Optional.Absent,
    fileShareStatus: Optional[FileShareStatus] = Optional.Absent,
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    kmsEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKey: Optional[KMSKey] = Optional.Absent,
    path: Optional[Path] = Optional.Absent,
    role: Optional[Role] = Optional.Absent,
    locationARN: Optional[LocationARN] = Optional.Absent,
    defaultStorageClass: Optional[StorageClass] = Optional.Absent,
    objectACL: Optional[zio.aws.storagegateway.model.ObjectACL] =
      Optional.Absent,
    readOnly: Optional[Boolean] = Optional.Absent,
    guessMIMETypeEnabled: Optional[Boolean] = Optional.Absent,
    requesterPays: Optional[Boolean] = Optional.Absent,
    smbaclEnabled: Optional[Boolean] = Optional.Absent,
    accessBasedEnumeration: Optional[Boolean] = Optional.Absent,
    adminUserList: Optional[Iterable[UserListUser]] = Optional.Absent,
    validUserList: Optional[Iterable[UserListUser]] = Optional.Absent,
    invalidUserList: Optional[Iterable[UserListUser]] = Optional.Absent,
    auditDestinationARN: Optional[AuditDestinationARN] = Optional.Absent,
    authentication: Optional[Authentication] = Optional.Absent,
    caseSensitivity: Optional[zio.aws.storagegateway.model.CaseSensitivity] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.storagegateway.model.Tag]] =
      Optional.Absent,
    fileShareName: Optional[FileShareName] = Optional.Absent,
    cacheAttributes: Optional[zio.aws.storagegateway.model.CacheAttributes] =
      Optional.Absent,
    notificationPolicy: Optional[NotificationPolicy] = Optional.Absent,
    vpcEndpointDNSName: Optional[DNSHostName] = Optional.Absent,
    bucketRegion: Optional[RegionId] = Optional.Absent,
    oplocksEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo = {
    import SMBFileShareInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo
      .builder()
      .optionallyWith(
        fileShareARN.map(value => FileShareARN.unwrap(value): java.lang.String)
      )(_.fileShareARN)
      .optionallyWith(
        fileShareId.map(value => FileShareId.unwrap(value): java.lang.String)
      )(_.fileShareId)
      .optionallyWith(
        fileShareStatus.map(value =>
          FileShareStatus.unwrap(value): java.lang.String
        )
      )(_.fileShareStatus)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(kmsEncrypted.map(value => value: java.lang.Boolean))(
        _.kmsEncrypted
      )
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(path.map(value => Path.unwrap(value): java.lang.String))(
        _.path
      )
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .optionallyWith(
        locationARN.map(value => LocationARN.unwrap(value): java.lang.String)
      )(_.locationARN)
      .optionallyWith(
        defaultStorageClass.map(value =>
          StorageClass.unwrap(value): java.lang.String
        )
      )(_.defaultStorageClass)
      .optionallyWith(objectACL.map(value => value.unwrap))(_.objectACL)
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(
        guessMIMETypeEnabled.map(value => value: java.lang.Boolean)
      )(_.guessMIMETypeEnabled)
      .optionallyWith(requesterPays.map(value => value: java.lang.Boolean))(
        _.requesterPays
      )
      .optionallyWith(smbaclEnabled.map(value => value: java.lang.Boolean))(
        _.smbaclEnabled
      )
      .optionallyWith(
        accessBasedEnumeration.map(value => value: java.lang.Boolean)
      )(_.accessBasedEnumeration)
      .optionallyWith(
        adminUserList.map(value =>
          value.map { item =>
            UserListUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.adminUserList)
      .optionallyWith(
        validUserList.map(value =>
          value.map { item =>
            UserListUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.validUserList)
      .optionallyWith(
        invalidUserList.map(value =>
          value.map { item =>
            UserListUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.invalidUserList)
      .optionallyWith(
        auditDestinationARN.map(value =>
          AuditDestinationARN.unwrap(value): java.lang.String
        )
      )(_.auditDestinationARN)
      .optionallyWith(
        authentication.map(value =>
          Authentication.unwrap(value): java.lang.String
        )
      )(_.authentication)
      .optionallyWith(caseSensitivity.map(value => value.unwrap))(
        _.caseSensitivity
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        fileShareName.map(value =>
          FileShareName.unwrap(value): java.lang.String
        )
      )(_.fileShareName)
      .optionallyWith(cacheAttributes.map(value => value.buildAwsValue()))(
        _.cacheAttributes
      )
      .optionallyWith(
        notificationPolicy.map(value =>
          NotificationPolicy.unwrap(value): java.lang.String
        )
      )(_.notificationPolicy)
      .optionallyWith(
        vpcEndpointDNSName.map(value =>
          DNSHostName.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointDNSName)
      .optionallyWith(
        bucketRegion.map(value => RegionId.unwrap(value): java.lang.String)
      )(_.bucketRegion)
      .optionallyWith(oplocksEnabled.map(value => value: java.lang.Boolean))(
        _.oplocksEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.SMBFileShareInfo.ReadOnly =
    zio.aws.storagegateway.model.SMBFileShareInfo.wrap(buildAwsValue())
}
object SMBFileShareInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.SMBFileShareInfo =
      zio.aws.storagegateway.model.SMBFileShareInfo(
        fileShareARN.map(value => value),
        fileShareId.map(value => value),
        fileShareStatus.map(value => value),
        gatewayARN.map(value => value),
        kmsEncrypted.map(value => value),
        kmsKey.map(value => value),
        path.map(value => value),
        role.map(value => value),
        locationARN.map(value => value),
        defaultStorageClass.map(value => value),
        objectACL.map(value => value),
        readOnly.map(value => value),
        guessMIMETypeEnabled.map(value => value),
        requesterPays.map(value => value),
        smbaclEnabled.map(value => value),
        accessBasedEnumeration.map(value => value),
        adminUserList.map(value => value),
        validUserList.map(value => value),
        invalidUserList.map(value => value),
        auditDestinationARN.map(value => value),
        authentication.map(value => value),
        caseSensitivity.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fileShareName.map(value => value),
        cacheAttributes.map(value => value.asEditable),
        notificationPolicy.map(value => value),
        vpcEndpointDNSName.map(value => value),
        bucketRegion.map(value => value),
        oplocksEnabled.map(value => value)
      )
    def fileShareARN: Optional[FileShareARN]
    def fileShareId: Optional[FileShareId]
    def fileShareStatus: Optional[FileShareStatus]
    def gatewayARN: Optional[GatewayARN]
    def kmsEncrypted: Optional[Boolean]
    def kmsKey: Optional[KMSKey]
    def path: Optional[Path]
    def role: Optional[Role]
    def locationARN: Optional[LocationARN]
    def defaultStorageClass: Optional[StorageClass]
    def objectACL: Optional[zio.aws.storagegateway.model.ObjectACL]
    def readOnly: Optional[Boolean]
    def guessMIMETypeEnabled: Optional[Boolean]
    def requesterPays: Optional[Boolean]
    def smbaclEnabled: Optional[Boolean]
    def accessBasedEnumeration: Optional[Boolean]
    def adminUserList: Optional[List[UserListUser]]
    def validUserList: Optional[List[UserListUser]]
    def invalidUserList: Optional[List[UserListUser]]
    def auditDestinationARN: Optional[AuditDestinationARN]
    def authentication: Optional[Authentication]
    def caseSensitivity: Optional[zio.aws.storagegateway.model.CaseSensitivity]
    def tags: Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def fileShareName: Optional[FileShareName]
    def cacheAttributes
        : Optional[zio.aws.storagegateway.model.CacheAttributes.ReadOnly]
    def notificationPolicy: Optional[NotificationPolicy]
    def vpcEndpointDNSName: Optional[DNSHostName]
    def bucketRegion: Optional[RegionId]
    def oplocksEnabled: Optional[Boolean]
    def getFileShareARN: ZIO[Any, AwsError, FileShareARN] =
      AwsError.unwrapOptionField("fileShareARN", fileShareARN)
    def getFileShareId: ZIO[Any, AwsError, FileShareId] =
      AwsError.unwrapOptionField("fileShareId", fileShareId)
    def getFileShareStatus: ZIO[Any, AwsError, FileShareStatus] =
      AwsError.unwrapOptionField("fileShareStatus", fileShareStatus)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getKmsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("kmsEncrypted", kmsEncrypted)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("path", path)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getLocationARN: ZIO[Any, AwsError, LocationARN] =
      AwsError.unwrapOptionField("locationARN", locationARN)
    def getDefaultStorageClass: ZIO[Any, AwsError, StorageClass] =
      AwsError.unwrapOptionField("defaultStorageClass", defaultStorageClass)
    def getObjectACL
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.ObjectACL] =
      AwsError.unwrapOptionField("objectACL", objectACL)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getGuessMIMETypeEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("guessMIMETypeEnabled", guessMIMETypeEnabled)
    def getRequesterPays: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterPays", requesterPays)
    def getSmbaclEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("smbaclEnabled", smbaclEnabled)
    def getAccessBasedEnumeration: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("accessBasedEnumeration", accessBasedEnumeration)
    def getAdminUserList: ZIO[Any, AwsError, List[UserListUser]] =
      AwsError.unwrapOptionField("adminUserList", adminUserList)
    def getValidUserList: ZIO[Any, AwsError, List[UserListUser]] =
      AwsError.unwrapOptionField("validUserList", validUserList)
    def getInvalidUserList: ZIO[Any, AwsError, List[UserListUser]] =
      AwsError.unwrapOptionField("invalidUserList", invalidUserList)
    def getAuditDestinationARN: ZIO[Any, AwsError, AuditDestinationARN] =
      AwsError.unwrapOptionField("auditDestinationARN", auditDestinationARN)
    def getAuthentication: ZIO[Any, AwsError, Authentication] =
      AwsError.unwrapOptionField("authentication", authentication)
    def getCaseSensitivity
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.CaseSensitivity] =
      AwsError.unwrapOptionField("caseSensitivity", caseSensitivity)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFileShareName: ZIO[Any, AwsError, FileShareName] =
      AwsError.unwrapOptionField("fileShareName", fileShareName)
    def getCacheAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.CacheAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("cacheAttributes", cacheAttributes)
    def getNotificationPolicy: ZIO[Any, AwsError, NotificationPolicy] =
      AwsError.unwrapOptionField("notificationPolicy", notificationPolicy)
    def getVpcEndpointDNSName: ZIO[Any, AwsError, DNSHostName] =
      AwsError.unwrapOptionField("vpcEndpointDNSName", vpcEndpointDNSName)
    def getBucketRegion: ZIO[Any, AwsError, RegionId] =
      AwsError.unwrapOptionField("bucketRegion", bucketRegion)
    def getOplocksEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("oplocksEnabled", oplocksEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo
  ) extends zio.aws.storagegateway.model.SMBFileShareInfo.ReadOnly {
    override val fileShareARN: Optional[FileShareARN] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareARN())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareARN(value))
    override val fileShareId: Optional[FileShareId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareId())
      .map(value => zio.aws.storagegateway.model.primitives.FileShareId(value))
    override val fileShareStatus: Optional[FileShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileShareStatus())
        .map(value =>
          zio.aws.storagegateway.model.primitives.FileShareStatus(value)
        )
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val kmsEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsEncrypted())
      .map(value => value: Boolean)
    override val kmsKey: Optional[KMSKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val path: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.storagegateway.model.primitives.Path(value))
    override val role: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.storagegateway.model.primitives.Role(value))
    override val locationARN: Optional[LocationARN] = zio.aws.core.internal
      .optionalFromNullable(impl.locationARN())
      .map(value => zio.aws.storagegateway.model.primitives.LocationARN(value))
    override val defaultStorageClass: Optional[StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultStorageClass())
        .map(value =>
          zio.aws.storagegateway.model.primitives.StorageClass(value)
        )
    override val objectACL: Optional[zio.aws.storagegateway.model.ObjectACL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectACL())
        .map(value => zio.aws.storagegateway.model.ObjectACL.wrap(value))
    override val readOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readOnly())
      .map(value => value: Boolean)
    override val guessMIMETypeEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.guessMIMETypeEnabled())
      .map(value => value: Boolean)
    override val requesterPays: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterPays())
      .map(value => value: Boolean)
    override val smbaclEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.smbaclEnabled())
      .map(value => value: Boolean)
    override val accessBasedEnumeration: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessBasedEnumeration())
        .map(value => value: Boolean)
    override val adminUserList: Optional[List[UserListUser]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adminUserList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.primitives.UserListUser(item)
          }.toList
        )
    override val validUserList: Optional[List[UserListUser]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validUserList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.primitives.UserListUser(item)
          }.toList
        )
    override val invalidUserList: Optional[List[UserListUser]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidUserList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.primitives.UserListUser(item)
          }.toList
        )
    override val auditDestinationARN: Optional[AuditDestinationARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditDestinationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives.AuditDestinationARN(value)
        )
    override val authentication: Optional[Authentication] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authentication())
        .map(value =>
          zio.aws.storagegateway.model.primitives.Authentication(value)
        )
    override val caseSensitivity
        : Optional[zio.aws.storagegateway.model.CaseSensitivity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caseSensitivity())
        .map(value => zio.aws.storagegateway.model.CaseSensitivity.wrap(value))
    override val tags
        : Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
    override val fileShareName: Optional[FileShareName] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareName())
      .map(value =>
        zio.aws.storagegateway.model.primitives.FileShareName(value)
      )
    override val cacheAttributes
        : Optional[zio.aws.storagegateway.model.CacheAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheAttributes())
        .map(value => zio.aws.storagegateway.model.CacheAttributes.wrap(value))
    override val notificationPolicy: Optional[NotificationPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationPolicy())
        .map(value =>
          zio.aws.storagegateway.model.primitives.NotificationPolicy(value)
        )
    override val vpcEndpointDNSName: Optional[DNSHostName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpointDNSName())
        .map(value =>
          zio.aws.storagegateway.model.primitives.DNSHostName(value)
        )
    override val bucketRegion: Optional[RegionId] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketRegion())
      .map(value => zio.aws.storagegateway.model.primitives.RegionId(value))
    override val oplocksEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.oplocksEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.SMBFileShareInfo
  ): zio.aws.storagegateway.model.SMBFileShareInfo.ReadOnly = new Wrapper(impl)
}
