package zio.aws.storagegateway.model
import scala.jdk.CollectionConverters.*
sealed trait CaseSensitivity {
  def unwrap
      : software.amazon.awssdk.services.storagegateway.model.CaseSensitivity
}
object CaseSensitivity {
  def wrap(
      value: software.amazon.awssdk.services.storagegateway.model.CaseSensitivity
  ): zio.aws.storagegateway.model.CaseSensitivity = value match {
    case software.amazon.awssdk.services.storagegateway.model.CaseSensitivity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.storagegateway.model.CaseSensitivity.CLIENT_SPECIFIED =>
      val r = ClientSpecified
      r
    case software.amazon.awssdk.services.storagegateway.model.CaseSensitivity.CASE_SENSITIVE =>
      val r = CaseSensitive
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.storagegateway.model.CaseSensitivity {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.CaseSensitivity =
      software.amazon.awssdk.services.storagegateway.model.CaseSensitivity.UNKNOWN_TO_SDK_VERSION
  }
  case object ClientSpecified
      extends zio.aws.storagegateway.model.CaseSensitivity {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.CaseSensitivity =
      software.amazon.awssdk.services.storagegateway.model.CaseSensitivity.CLIENT_SPECIFIED
  }
  case object CaseSensitive
      extends zio.aws.storagegateway.model.CaseSensitivity {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.CaseSensitivity =
      software.amazon.awssdk.services.storagegateway.model.CaseSensitivity.CASE_SENSITIVE
  }
}
