package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  KMSKey,
  NetworkInterfaceId,
  VolumeARN,
  GatewayARN,
  SnapshotId,
  ClientToken,
  TargetName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCachediScsiVolumeRequest(
    gatewayARN: GatewayARN,
    volumeSizeInBytes: Long,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    targetName: TargetName,
    sourceVolumeARN: Optional[VolumeARN] = Optional.Absent,
    networkInterfaceId: NetworkInterfaceId,
    clientToken: ClientToken,
    kmsEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKey: Optional[KMSKey] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.storagegateway.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeRequest = {
    import CreateCachediScsiVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .volumeSizeInBytes(volumeSizeInBytes: java.lang.Long)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .targetName(TargetName.unwrap(targetName): java.lang.String)
      .optionallyWith(
        sourceVolumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.sourceVolumeARN)
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(kmsEncrypted.map(value => value: java.lang.Boolean))(
        _.kmsEncrypted
      )
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.CreateCachediScsiVolumeRequest.ReadOnly =
    zio.aws.storagegateway.model.CreateCachediScsiVolumeRequest
      .wrap(buildAwsValue())
}
object CreateCachediScsiVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.CreateCachediScsiVolumeRequest =
      zio.aws.storagegateway.model.CreateCachediScsiVolumeRequest(
        gatewayARN,
        volumeSizeInBytes,
        snapshotId.map(value => value),
        targetName,
        sourceVolumeARN.map(value => value),
        networkInterfaceId,
        clientToken,
        kmsEncrypted.map(value => value),
        kmsKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gatewayARN: GatewayARN
    def volumeSizeInBytes: Long
    def snapshotId: Optional[SnapshotId]
    def targetName: TargetName
    def sourceVolumeARN: Optional[VolumeARN]
    def networkInterfaceId: NetworkInterfaceId
    def clientToken: ClientToken
    def kmsEncrypted: Optional[Boolean]
    def kmsKey: Optional[KMSKey]
    def tags: Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getVolumeSizeInBytes: ZIO[Any, Nothing, Long] =
      ZIO.succeed(volumeSizeInBytes)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getTargetName: ZIO[Any, Nothing, TargetName] = ZIO.succeed(targetName)
    def getSourceVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("sourceVolumeARN", sourceVolumeARN)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getKmsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("kmsEncrypted", kmsEncrypted)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeRequest
  ) extends zio.aws.storagegateway.model.CreateCachediScsiVolumeRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val volumeSizeInBytes: Long = impl.volumeSizeInBytes(): Long
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.storagegateway.model.primitives.SnapshotId(value))
    override val targetName: TargetName =
      zio.aws.storagegateway.model.primitives.TargetName(impl.targetName())
    override val sourceVolumeARN: Optional[VolumeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVolumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.storagegateway.model.primitives
        .NetworkInterfaceId(impl.networkInterfaceId())
    override val clientToken: ClientToken =
      zio.aws.storagegateway.model.primitives.ClientToken(impl.clientToken())
    override val kmsEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsEncrypted())
      .map(value => value: Boolean)
    override val kmsKey: Optional[KMSKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val tags
        : Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeRequest
  ): zio.aws.storagegateway.model.CreateCachediScsiVolumeRequest.ReadOnly =
    new Wrapper(impl)
}
