package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  MinimumNumTapes,
  TapeSize,
  PoolId,
  TapeBarcodePrefix
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AutomaticTapeCreationRule(
    tapeBarcodePrefix: TapeBarcodePrefix,
    poolId: PoolId,
    tapeSizeInBytes: TapeSize,
    minimumNumTapes: MinimumNumTapes,
    worm: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationRule = {
    import AutomaticTapeCreationRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationRule
      .builder()
      .tapeBarcodePrefix(
        TapeBarcodePrefix.unwrap(tapeBarcodePrefix): java.lang.String
      )
      .poolId(PoolId.unwrap(poolId): java.lang.String)
      .tapeSizeInBytes(TapeSize.unwrap(tapeSizeInBytes): java.lang.Long)
      .minimumNumTapes(MinimumNumTapes.unwrap(minimumNumTapes): Integer)
      .optionallyWith(worm.map(value => value: java.lang.Boolean))(_.worm)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.AutomaticTapeCreationRule.ReadOnly =
    zio.aws.storagegateway.model.AutomaticTapeCreationRule.wrap(buildAwsValue())
}
object AutomaticTapeCreationRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AutomaticTapeCreationRule =
      zio.aws.storagegateway.model.AutomaticTapeCreationRule(
        tapeBarcodePrefix,
        poolId,
        tapeSizeInBytes,
        minimumNumTapes,
        worm.map(value => value)
      )
    def tapeBarcodePrefix: TapeBarcodePrefix
    def poolId: PoolId
    def tapeSizeInBytes: TapeSize
    def minimumNumTapes: MinimumNumTapes
    def worm: Optional[Boolean]
    def getTapeBarcodePrefix: ZIO[Any, Nothing, TapeBarcodePrefix] =
      ZIO.succeed(tapeBarcodePrefix)
    def getPoolId: ZIO[Any, Nothing, PoolId] = ZIO.succeed(poolId)
    def getTapeSizeInBytes: ZIO[Any, Nothing, TapeSize] =
      ZIO.succeed(tapeSizeInBytes)
    def getMinimumNumTapes: ZIO[Any, Nothing, MinimumNumTapes] =
      ZIO.succeed(minimumNumTapes)
    def getWorm: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("worm", worm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationRule
  ) extends zio.aws.storagegateway.model.AutomaticTapeCreationRule.ReadOnly {
    override val tapeBarcodePrefix: TapeBarcodePrefix =
      zio.aws.storagegateway.model.primitives
        .TapeBarcodePrefix(impl.tapeBarcodePrefix())
    override val poolId: PoolId =
      zio.aws.storagegateway.model.primitives.PoolId(impl.poolId())
    override val tapeSizeInBytes: TapeSize =
      zio.aws.storagegateway.model.primitives.TapeSize(impl.tapeSizeInBytes())
    override val minimumNumTapes: MinimumNumTapes =
      zio.aws.storagegateway.model.primitives
        .MinimumNumTapes(impl.minimumNumTapes())
    override val worm: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.worm())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationRule
  ): zio.aws.storagegateway.model.AutomaticTapeCreationRule.ReadOnly =
    new Wrapper(impl)
}
