package zio.aws.storagegateway.model
import scala.jdk.CollectionConverters.*
sealed trait ActiveDirectoryStatus {
  def unwrap: software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus
}
object ActiveDirectoryStatus {
  def wrap(
      value: software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus
  ): zio.aws.storagegateway.model.ActiveDirectoryStatus = value match {
    case software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.DETACHED =>
      val r = DETACHED
      r
    case software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.JOINED =>
      val r = JOINED
      r
    case software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.JOINING =>
      val r = JOINING
      r
    case software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.NETWORK_ERROR =>
      val r = NETWORK_ERROR
      r
    case software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.TIMEOUT =>
      val r = TIMEOUT
      r
    case software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.UNKNOWN_ERROR =>
      val r = UNKNOWN_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.storagegateway.model.ActiveDirectoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus =
      software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCESS_DENIED
      extends zio.aws.storagegateway.model.ActiveDirectoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus =
      software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.ACCESS_DENIED
  }
  case object DETACHED
      extends zio.aws.storagegateway.model.ActiveDirectoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus =
      software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.DETACHED
  }
  case object JOINED
      extends zio.aws.storagegateway.model.ActiveDirectoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus =
      software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.JOINED
  }
  case object JOINING
      extends zio.aws.storagegateway.model.ActiveDirectoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus =
      software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.JOINING
  }
  case object NETWORK_ERROR
      extends zio.aws.storagegateway.model.ActiveDirectoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus =
      software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.NETWORK_ERROR
  }
  case object TIMEOUT
      extends zio.aws.storagegateway.model.ActiveDirectoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus =
      software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.TIMEOUT
  }
  case object UNKNOWN_ERROR
      extends zio.aws.storagegateway.model.ActiveDirectoryStatus {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus =
      software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus.UNKNOWN_ERROR
  }
}
