package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Integer,
  NetworkInterfaceId,
  TargetARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VolumeiSCSIAttributes(
    targetARN: Optional[TargetARN] = Optional.Absent,
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent,
    networkInterfacePort: Optional[Integer] = Optional.Absent,
    lunNumber: Optional[PositiveIntObject] = Optional.Absent,
    chapEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.VolumeiSCSIAttributes = {
    import VolumeiSCSIAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.VolumeiSCSIAttributes
      .builder()
      .optionallyWith(
        targetARN.map(value => TargetARN.unwrap(value): java.lang.String)
      )(_.targetARN)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        networkInterfacePort.map(value => value: java.lang.Integer)
      )(_.networkInterfacePort)
      .optionallyWith(
        lunNumber.map(value =>
          PositiveIntObject.unwrap(value): java.lang.Integer
        )
      )(_.lunNumber)
      .optionallyWith(chapEnabled.map(value => value: java.lang.Boolean))(
        _.chapEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly =
    zio.aws.storagegateway.model.VolumeiSCSIAttributes.wrap(buildAwsValue())
}
object VolumeiSCSIAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.VolumeiSCSIAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.VolumeiSCSIAttributes =
      zio.aws.storagegateway.model.VolumeiSCSIAttributes(
        targetARN.map(value => value),
        networkInterfaceId.map(value => value),
        networkInterfacePort.map(value => value),
        lunNumber.map(value => value),
        chapEnabled.map(value => value)
      )
    def targetARN: Optional[TargetARN]
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def networkInterfacePort: Optional[Integer]
    def lunNumber: Optional[PositiveIntObject]
    def chapEnabled: Optional[Boolean]
    def getTargetARN: ZIO[Any, AwsError, TargetARN] =
      AwsError.unwrapOptionField("targetARN", targetARN)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getNetworkInterfacePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkInterfacePort", networkInterfacePort)
    def getLunNumber: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("lunNumber", lunNumber)
    def getChapEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("chapEnabled", chapEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.VolumeiSCSIAttributes
  ) extends zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly {
    override val targetARN: Optional[TargetARN] = zio.aws.core.internal
      .optionalFromNullable(impl.targetARN())
      .map(value => zio.aws.storagegateway.model.primitives.TargetARN(value))
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value =>
          zio.aws.storagegateway.model.primitives.NetworkInterfaceId(value)
        )
    override val networkInterfacePort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfacePort())
      .map(value => value: Integer)
    override val lunNumber: Optional[PositiveIntObject] = zio.aws.core.internal
      .optionalFromNullable(impl.lunNumber())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
    override val chapEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.chapEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.VolumeiSCSIAttributes
  ): zio.aws.storagegateway.model.VolumeiSCSIAttributes.ReadOnly = new Wrapper(
    impl
  )
}
