package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  CloudWatchLogGroupARN,
  GatewayTimezone,
  GatewayName,
  GatewayARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateGatewayInformationRequest(
    gatewayARN: GatewayARN,
    gatewayName: Optional[GatewayName] = Optional.Absent,
    gatewayTimezone: Optional[GatewayTimezone] = Optional.Absent,
    cloudWatchLogGroupARN: Optional[CloudWatchLogGroupARN] = Optional.Absent,
    gatewayCapacity: Optional[zio.aws.storagegateway.model.GatewayCapacity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationRequest = {
    import UpdateGatewayInformationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .optionallyWith(
        gatewayName.map(value => GatewayName.unwrap(value): java.lang.String)
      )(_.gatewayName)
      .optionallyWith(
        gatewayTimezone.map(value =>
          GatewayTimezone.unwrap(value): java.lang.String
        )
      )(_.gatewayTimezone)
      .optionallyWith(
        cloudWatchLogGroupARN.map(value =>
          CloudWatchLogGroupARN.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupARN)
      .optionallyWith(gatewayCapacity.map(value => value.unwrap))(
        _.gatewayCapacity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateGatewayInformationRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateGatewayInformationRequest
      .wrap(buildAwsValue())
}
object UpdateGatewayInformationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateGatewayInformationRequest =
      zio.aws.storagegateway.model.UpdateGatewayInformationRequest(
        gatewayARN,
        gatewayName.map(value => value),
        gatewayTimezone.map(value => value),
        cloudWatchLogGroupARN.map(value => value),
        gatewayCapacity.map(value => value)
      )
    def gatewayARN: GatewayARN
    def gatewayName: Optional[GatewayName]
    def gatewayTimezone: Optional[GatewayTimezone]
    def cloudWatchLogGroupARN: Optional[CloudWatchLogGroupARN]
    def gatewayCapacity: Optional[zio.aws.storagegateway.model.GatewayCapacity]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getGatewayName: ZIO[Any, AwsError, GatewayName] =
      AwsError.unwrapOptionField("gatewayName", gatewayName)
    def getGatewayTimezone: ZIO[Any, AwsError, GatewayTimezone] =
      AwsError.unwrapOptionField("gatewayTimezone", gatewayTimezone)
    def getCloudWatchLogGroupARN: ZIO[Any, AwsError, CloudWatchLogGroupARN] =
      AwsError.unwrapOptionField("cloudWatchLogGroupARN", cloudWatchLogGroupARN)
    def getGatewayCapacity
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.GatewayCapacity] =
      AwsError.unwrapOptionField("gatewayCapacity", gatewayCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationRequest
  ) extends zio.aws.storagegateway.model.UpdateGatewayInformationRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val gatewayName: Optional[GatewayName] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayName())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayName(value))
    override val gatewayTimezone: Optional[GatewayTimezone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayTimezone())
        .map(value =>
          zio.aws.storagegateway.model.primitives.GatewayTimezone(value)
        )
    override val cloudWatchLogGroupARN: Optional[CloudWatchLogGroupARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives.CloudWatchLogGroupARN(value)
        )
    override val gatewayCapacity
        : Optional[zio.aws.storagegateway.model.GatewayCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayCapacity())
        .map(value => zio.aws.storagegateway.model.GatewayCapacity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationRequest
  ): zio.aws.storagegateway.model.UpdateGatewayInformationRequest.ReadOnly =
    new Wrapper(impl)
}
