package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListGatewaysResponse(
    gateways: Optional[Iterable[zio.aws.storagegateway.model.GatewayInfo]] =
      Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse = {
    import ListGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse
      .builder()
      .optionallyWith(
        gateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gateways)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListGatewaysResponse.ReadOnly =
    zio.aws.storagegateway.model.ListGatewaysResponse.wrap(buildAwsValue())
}
object ListGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListGatewaysResponse =
      zio.aws.storagegateway.model.ListGatewaysResponse(
        gateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def gateways
        : Optional[List[zio.aws.storagegateway.model.GatewayInfo.ReadOnly]]
    def marker: Optional[Marker]
    def getGateways: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.GatewayInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("gateways", gateways)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse
  ) extends zio.aws.storagegateway.model.ListGatewaysResponse.ReadOnly {
    override val gateways
        : Optional[List[zio.aws.storagegateway.model.GatewayInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.GatewayInfo.wrap(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse
  ): zio.aws.storagegateway.model.ListGatewaysResponse.ReadOnly = new Wrapper(
    impl
  )
}
