package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLocalDisksResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    disks: Optional[Iterable[zio.aws.storagegateway.model.Disk]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListLocalDisksResponse = {
    import ListLocalDisksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListLocalDisksResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        disks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.disks)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListLocalDisksResponse.ReadOnly =
    zio.aws.storagegateway.model.ListLocalDisksResponse.wrap(buildAwsValue())
}
object ListLocalDisksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListLocalDisksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListLocalDisksResponse =
      zio.aws.storagegateway.model.ListLocalDisksResponse(
        gatewayARN.map(value => value),
        disks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gatewayARN: Optional[GatewayARN]
    def disks: Optional[List[zio.aws.storagegateway.model.Disk.ReadOnly]]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getDisks
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Disk.ReadOnly]] =
      AwsError.unwrapOptionField("disks", disks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListLocalDisksResponse
  ) extends zio.aws.storagegateway.model.ListLocalDisksResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val disks
        : Optional[List[zio.aws.storagegateway.model.Disk.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Disk.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListLocalDisksResponse
  ): zio.aws.storagegateway.model.ListLocalDisksResponse.ReadOnly = new Wrapper(
    impl
  )
}
