package zio.aws.storagegateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFileSystemAssociationsResponse(
    fileSystemAssociationInfoList: Optional[
      Iterable[zio.aws.storagegateway.model.FileSystemAssociationInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsResponse = {
    import DescribeFileSystemAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsResponse
      .builder()
      .optionallyWith(
        fileSystemAssociationInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemAssociationInfoList)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeFileSystemAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse =
      zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse(
        fileSystemAssociationInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fileSystemAssociationInfoList: Optional[
      List[zio.aws.storagegateway.model.FileSystemAssociationInfo.ReadOnly]
    ]
    def getFileSystemAssociationInfoList: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.FileSystemAssociationInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fileSystemAssociationInfoList",
      fileSystemAssociationInfoList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsResponse
  ) extends zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse.ReadOnly {
    override val fileSystemAssociationInfoList: Optional[
      List[zio.aws.storagegateway.model.FileSystemAssociationInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemAssociationInfoList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.FileSystemAssociationInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsResponse
  ): zio.aws.storagegateway.model.DescribeFileSystemAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
