package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  GatewayId,
  VolumeARN,
  GatewayARN,
  VolumeId,
  VolumeAttachmentStatus,
  VolumeType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VolumeInfo(
    volumeARN: Optional[VolumeARN] = Optional.Absent,
    volumeId: Optional[VolumeId] = Optional.Absent,
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    gatewayId: Optional[GatewayId] = Optional.Absent,
    volumeType: Optional[VolumeType] = Optional.Absent,
    volumeSizeInBytes: Optional[Long] = Optional.Absent,
    volumeAttachmentStatus: Optional[VolumeAttachmentStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.VolumeInfo = {
    import VolumeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.VolumeInfo
      .builder()
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        gatewayId.map(value => GatewayId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(
        volumeType.map(value => VolumeType.unwrap(value): java.lang.String)
      )(_.volumeType)
      .optionallyWith(volumeSizeInBytes.map(value => value: java.lang.Long))(
        _.volumeSizeInBytes
      )
      .optionallyWith(
        volumeAttachmentStatus.map(value =>
          VolumeAttachmentStatus.unwrap(value): java.lang.String
        )
      )(_.volumeAttachmentStatus)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.VolumeInfo.ReadOnly =
    zio.aws.storagegateway.model.VolumeInfo.wrap(buildAwsValue())
}
object VolumeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.VolumeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.VolumeInfo =
      zio.aws.storagegateway.model.VolumeInfo(
        volumeARN.map(value => value),
        volumeId.map(value => value),
        gatewayARN.map(value => value),
        gatewayId.map(value => value),
        volumeType.map(value => value),
        volumeSizeInBytes.map(value => value),
        volumeAttachmentStatus.map(value => value)
      )
    def volumeARN: Optional[VolumeARN]
    def volumeId: Optional[VolumeId]
    def gatewayARN: Optional[GatewayARN]
    def gatewayId: Optional[GatewayId]
    def volumeType: Optional[VolumeType]
    def volumeSizeInBytes: Optional[Long]
    def volumeAttachmentStatus: Optional[VolumeAttachmentStatus]
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getGatewayId: ZIO[Any, AwsError, GatewayId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getVolumeType: ZIO[Any, AwsError, VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getVolumeSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("volumeSizeInBytes", volumeSizeInBytes)
    def getVolumeAttachmentStatus: ZIO[Any, AwsError, VolumeAttachmentStatus] =
      AwsError.unwrapOptionField(
        "volumeAttachmentStatus",
        volumeAttachmentStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.VolumeInfo
  ) extends zio.aws.storagegateway.model.VolumeInfo.ReadOnly {
    override val volumeARN: Optional[VolumeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val volumeId: Optional[VolumeId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeId(value))
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val gatewayId: Optional[GatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayId(value))
    override val volumeType: Optional[VolumeType] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeType())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeType(value))
    override val volumeSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSizeInBytes())
      .map(value => value: Long)
    override val volumeAttachmentStatus: Optional[VolumeAttachmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeAttachmentStatus())
        .map(value =>
          zio.aws.storagegateway.model.primitives.VolumeAttachmentStatus(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.VolumeInfo
  ): zio.aws.storagegateway.model.VolumeInfo.ReadOnly = new Wrapper(impl)
}
