package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListVolumeRecoveryPointsRequest(gatewayARN: GatewayARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsRequest = {
    import ListVolumeRecoveryPointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.ListVolumeRecoveryPointsRequest.ReadOnly =
    zio.aws.storagegateway.model.ListVolumeRecoveryPointsRequest
      .wrap(buildAwsValue())
}
object ListVolumeRecoveryPointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.ListVolumeRecoveryPointsRequest =
      zio.aws.storagegateway.model.ListVolumeRecoveryPointsRequest(gatewayARN)
    def gatewayARN: GatewayARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsRequest
  ) extends zio.aws.storagegateway.model.ListVolumeRecoveryPointsRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsRequest
  ): zio.aws.storagegateway.model.ListVolumeRecoveryPointsRequest.ReadOnly =
    new Wrapper(impl)
}
