package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  StorageClass,
  UserListUser,
  KMSKey,
  AuditDestinationARN,
  FileShareName,
  FileShareARN,
  NotificationPolicy
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSmbFileShareRequest(
    fileShareARN: FileShareARN,
    kmsEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKey: Optional[KMSKey] = Optional.Absent,
    defaultStorageClass: Optional[StorageClass] = Optional.Absent,
    objectACL: Optional[zio.aws.storagegateway.model.ObjectACL] =
      Optional.Absent,
    readOnly: Optional[Boolean] = Optional.Absent,
    guessMIMETypeEnabled: Optional[Boolean] = Optional.Absent,
    requesterPays: Optional[Boolean] = Optional.Absent,
    smbaclEnabled: Optional[Boolean] = Optional.Absent,
    accessBasedEnumeration: Optional[Boolean] = Optional.Absent,
    adminUserList: Optional[Iterable[UserListUser]] = Optional.Absent,
    validUserList: Optional[Iterable[UserListUser]] = Optional.Absent,
    invalidUserList: Optional[Iterable[UserListUser]] = Optional.Absent,
    auditDestinationARN: Optional[AuditDestinationARN] = Optional.Absent,
    caseSensitivity: Optional[zio.aws.storagegateway.model.CaseSensitivity] =
      Optional.Absent,
    fileShareName: Optional[FileShareName] = Optional.Absent,
    cacheAttributes: Optional[zio.aws.storagegateway.model.CacheAttributes] =
      Optional.Absent,
    notificationPolicy: Optional[NotificationPolicy] = Optional.Absent,
    oplocksEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareRequest = {
    import UpdateSmbFileShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareRequest
      .builder()
      .fileShareARN(FileShareARN.unwrap(fileShareARN): java.lang.String)
      .optionallyWith(kmsEncrypted.map(value => value: java.lang.Boolean))(
        _.kmsEncrypted
      )
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        defaultStorageClass.map(value =>
          StorageClass.unwrap(value): java.lang.String
        )
      )(_.defaultStorageClass)
      .optionallyWith(objectACL.map(value => value.unwrap))(_.objectACL)
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(
        guessMIMETypeEnabled.map(value => value: java.lang.Boolean)
      )(_.guessMIMETypeEnabled)
      .optionallyWith(requesterPays.map(value => value: java.lang.Boolean))(
        _.requesterPays
      )
      .optionallyWith(smbaclEnabled.map(value => value: java.lang.Boolean))(
        _.smbaclEnabled
      )
      .optionallyWith(
        accessBasedEnumeration.map(value => value: java.lang.Boolean)
      )(_.accessBasedEnumeration)
      .optionallyWith(
        adminUserList.map(value =>
          value.map { item =>
            UserListUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.adminUserList)
      .optionallyWith(
        validUserList.map(value =>
          value.map { item =>
            UserListUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.validUserList)
      .optionallyWith(
        invalidUserList.map(value =>
          value.map { item =>
            UserListUser.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.invalidUserList)
      .optionallyWith(
        auditDestinationARN.map(value =>
          AuditDestinationARN.unwrap(value): java.lang.String
        )
      )(_.auditDestinationARN)
      .optionallyWith(caseSensitivity.map(value => value.unwrap))(
        _.caseSensitivity
      )
      .optionallyWith(
        fileShareName.map(value =>
          FileShareName.unwrap(value): java.lang.String
        )
      )(_.fileShareName)
      .optionallyWith(cacheAttributes.map(value => value.buildAwsValue()))(
        _.cacheAttributes
      )
      .optionallyWith(
        notificationPolicy.map(value =>
          NotificationPolicy.unwrap(value): java.lang.String
        )
      )(_.notificationPolicy)
      .optionallyWith(oplocksEnabled.map(value => value: java.lang.Boolean))(
        _.oplocksEnabled
      )
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateSmbFileShareRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateSmbFileShareRequest.wrap(buildAwsValue())
}
object UpdateSmbFileShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.UpdateSmbFileShareRequest =
      zio.aws.storagegateway.model.UpdateSmbFileShareRequest(
        fileShareARN,
        kmsEncrypted.map(value => value),
        kmsKey.map(value => value),
        defaultStorageClass.map(value => value),
        objectACL.map(value => value),
        readOnly.map(value => value),
        guessMIMETypeEnabled.map(value => value),
        requesterPays.map(value => value),
        smbaclEnabled.map(value => value),
        accessBasedEnumeration.map(value => value),
        adminUserList.map(value => value),
        validUserList.map(value => value),
        invalidUserList.map(value => value),
        auditDestinationARN.map(value => value),
        caseSensitivity.map(value => value),
        fileShareName.map(value => value),
        cacheAttributes.map(value => value.asEditable),
        notificationPolicy.map(value => value),
        oplocksEnabled.map(value => value)
      )
    def fileShareARN: FileShareARN
    def kmsEncrypted: Optional[Boolean]
    def kmsKey: Optional[KMSKey]
    def defaultStorageClass: Optional[StorageClass]
    def objectACL: Optional[zio.aws.storagegateway.model.ObjectACL]
    def readOnly: Optional[Boolean]
    def guessMIMETypeEnabled: Optional[Boolean]
    def requesterPays: Optional[Boolean]
    def smbaclEnabled: Optional[Boolean]
    def accessBasedEnumeration: Optional[Boolean]
    def adminUserList: Optional[List[UserListUser]]
    def validUserList: Optional[List[UserListUser]]
    def invalidUserList: Optional[List[UserListUser]]
    def auditDestinationARN: Optional[AuditDestinationARN]
    def caseSensitivity: Optional[zio.aws.storagegateway.model.CaseSensitivity]
    def fileShareName: Optional[FileShareName]
    def cacheAttributes
        : Optional[zio.aws.storagegateway.model.CacheAttributes.ReadOnly]
    def notificationPolicy: Optional[NotificationPolicy]
    def oplocksEnabled: Optional[Boolean]
    def getFileShareARN: ZIO[Any, Nothing, FileShareARN] =
      ZIO.succeed(fileShareARN)
    def getKmsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("kmsEncrypted", kmsEncrypted)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getDefaultStorageClass: ZIO[Any, AwsError, StorageClass] =
      AwsError.unwrapOptionField("defaultStorageClass", defaultStorageClass)
    def getObjectACL
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.ObjectACL] =
      AwsError.unwrapOptionField("objectACL", objectACL)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getGuessMIMETypeEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("guessMIMETypeEnabled", guessMIMETypeEnabled)
    def getRequesterPays: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterPays", requesterPays)
    def getSmbaclEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("smbaclEnabled", smbaclEnabled)
    def getAccessBasedEnumeration: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("accessBasedEnumeration", accessBasedEnumeration)
    def getAdminUserList: ZIO[Any, AwsError, List[UserListUser]] =
      AwsError.unwrapOptionField("adminUserList", adminUserList)
    def getValidUserList: ZIO[Any, AwsError, List[UserListUser]] =
      AwsError.unwrapOptionField("validUserList", validUserList)
    def getInvalidUserList: ZIO[Any, AwsError, List[UserListUser]] =
      AwsError.unwrapOptionField("invalidUserList", invalidUserList)
    def getAuditDestinationARN: ZIO[Any, AwsError, AuditDestinationARN] =
      AwsError.unwrapOptionField("auditDestinationARN", auditDestinationARN)
    def getCaseSensitivity
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.CaseSensitivity] =
      AwsError.unwrapOptionField("caseSensitivity", caseSensitivity)
    def getFileShareName: ZIO[Any, AwsError, FileShareName] =
      AwsError.unwrapOptionField("fileShareName", fileShareName)
    def getCacheAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.CacheAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("cacheAttributes", cacheAttributes)
    def getNotificationPolicy: ZIO[Any, AwsError, NotificationPolicy] =
      AwsError.unwrapOptionField("notificationPolicy", notificationPolicy)
    def getOplocksEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("oplocksEnabled", oplocksEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareRequest
  ) extends zio.aws.storagegateway.model.UpdateSmbFileShareRequest.ReadOnly {
    override val fileShareARN: FileShareARN =
      zio.aws.storagegateway.model.primitives.FileShareARN(impl.fileShareARN())
    override val kmsEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsEncrypted())
      .map(value => value: Boolean)
    override val kmsKey: Optional[KMSKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val defaultStorageClass: Optional[StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultStorageClass())
        .map(value =>
          zio.aws.storagegateway.model.primitives.StorageClass(value)
        )
    override val objectACL: Optional[zio.aws.storagegateway.model.ObjectACL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectACL())
        .map(value => zio.aws.storagegateway.model.ObjectACL.wrap(value))
    override val readOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readOnly())
      .map(value => value: Boolean)
    override val guessMIMETypeEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.guessMIMETypeEnabled())
      .map(value => value: Boolean)
    override val requesterPays: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterPays())
      .map(value => value: Boolean)
    override val smbaclEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.smbaclEnabled())
      .map(value => value: Boolean)
    override val accessBasedEnumeration: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessBasedEnumeration())
        .map(value => value: Boolean)
    override val adminUserList: Optional[List[UserListUser]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adminUserList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.primitives.UserListUser(item)
          }.toList
        )
    override val validUserList: Optional[List[UserListUser]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validUserList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.primitives.UserListUser(item)
          }.toList
        )
    override val invalidUserList: Optional[List[UserListUser]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidUserList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.primitives.UserListUser(item)
          }.toList
        )
    override val auditDestinationARN: Optional[AuditDestinationARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditDestinationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives.AuditDestinationARN(value)
        )
    override val caseSensitivity
        : Optional[zio.aws.storagegateway.model.CaseSensitivity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caseSensitivity())
        .map(value => zio.aws.storagegateway.model.CaseSensitivity.wrap(value))
    override val fileShareName: Optional[FileShareName] = zio.aws.core.internal
      .optionalFromNullable(impl.fileShareName())
      .map(value =>
        zio.aws.storagegateway.model.primitives.FileShareName(value)
      )
    override val cacheAttributes
        : Optional[zio.aws.storagegateway.model.CacheAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheAttributes())
        .map(value => zio.aws.storagegateway.model.CacheAttributes.wrap(value))
    override val notificationPolicy: Optional[NotificationPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationPolicy())
        .map(value =>
          zio.aws.storagegateway.model.primitives.NotificationPolicy(value)
        )
    override val oplocksEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.oplocksEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareRequest
  ): zio.aws.storagegateway.model.UpdateSmbFileShareRequest.ReadOnly =
    new Wrapper(impl)
}
