package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  PositiveIntObject,
  Marker,
  GatewayARN
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeTapeRecoveryPointsRequest(
    gatewayARN: GatewayARN,
    marker: Optional[Marker] = Optional.Absent,
    limit: Optional[PositiveIntObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest = {
    import DescribeTapeRecoveryPointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest
      .wrap(buildAwsValue())
}
object DescribeTapeRecoveryPointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest =
      zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest(
        gatewayARN,
        marker.map(value => value),
        limit.map(value => value)
      )
    def gatewayARN: GatewayARN
    def marker: Optional[Marker]
    def limit: Optional[PositiveIntObject]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest
  ) extends zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val limit: Optional[PositiveIntObject] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest
  ): zio.aws.storagegateway.model.DescribeTapeRecoveryPointsRequest.ReadOnly =
    new Wrapper(impl)
}
