package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeBandwidthRateLimitRequest(gatewayARN: GatewayARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitRequest = {
    import DescribeBandwidthRateLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeBandwidthRateLimitRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeBandwidthRateLimitRequest
      .wrap(buildAwsValue())
}
object DescribeBandwidthRateLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeBandwidthRateLimitRequest =
      zio.aws.storagegateway.model.DescribeBandwidthRateLimitRequest(gatewayARN)
    def gatewayARN: GatewayARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitRequest
  ) extends zio.aws.storagegateway.model.DescribeBandwidthRateLimitRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitRequest
  ): zio.aws.storagegateway.model.DescribeBandwidthRateLimitRequest.ReadOnly =
    new Wrapper(impl)
}
