package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  GatewayType,
  GatewayName,
  ActivationKey,
  TapeDriveType,
  RegionId,
  GatewayTimezone,
  MediumChangerType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActivateGatewayRequest(
    activationKey: ActivationKey,
    gatewayName: GatewayName,
    gatewayTimezone: GatewayTimezone,
    gatewayRegion: RegionId,
    gatewayType: Optional[GatewayType] = Optional.Absent,
    tapeDriveType: Optional[TapeDriveType] = Optional.Absent,
    mediumChangerType: Optional[MediumChangerType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.storagegateway.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ActivateGatewayRequest = {
    import ActivateGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ActivateGatewayRequest
      .builder()
      .activationKey(ActivationKey.unwrap(activationKey): java.lang.String)
      .gatewayName(GatewayName.unwrap(gatewayName): java.lang.String)
      .gatewayTimezone(
        GatewayTimezone.unwrap(gatewayTimezone): java.lang.String
      )
      .gatewayRegion(RegionId.unwrap(gatewayRegion): java.lang.String)
      .optionallyWith(
        gatewayType.map(value => GatewayType.unwrap(value): java.lang.String)
      )(_.gatewayType)
      .optionallyWith(
        tapeDriveType.map(value =>
          TapeDriveType.unwrap(value): java.lang.String
        )
      )(_.tapeDriveType)
      .optionallyWith(
        mediumChangerType.map(value =>
          MediumChangerType.unwrap(value): java.lang.String
        )
      )(_.mediumChangerType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ActivateGatewayRequest.ReadOnly =
    zio.aws.storagegateway.model.ActivateGatewayRequest.wrap(buildAwsValue())
}
object ActivateGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ActivateGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ActivateGatewayRequest =
      zio.aws.storagegateway.model.ActivateGatewayRequest(
        activationKey,
        gatewayName,
        gatewayTimezone,
        gatewayRegion,
        gatewayType.map(value => value),
        tapeDriveType.map(value => value),
        mediumChangerType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def activationKey: ActivationKey
    def gatewayName: GatewayName
    def gatewayTimezone: GatewayTimezone
    def gatewayRegion: RegionId
    def gatewayType: Optional[GatewayType]
    def tapeDriveType: Optional[TapeDriveType]
    def mediumChangerType: Optional[MediumChangerType]
    def tags: Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def getActivationKey: ZIO[Any, Nothing, ActivationKey] =
      ZIO.succeed(activationKey)
    def getGatewayName: ZIO[Any, Nothing, GatewayName] =
      ZIO.succeed(gatewayName)
    def getGatewayTimezone: ZIO[Any, Nothing, GatewayTimezone] =
      ZIO.succeed(gatewayTimezone)
    def getGatewayRegion: ZIO[Any, Nothing, RegionId] =
      ZIO.succeed(gatewayRegion)
    def getGatewayType: ZIO[Any, AwsError, GatewayType] =
      AwsError.unwrapOptionField("gatewayType", gatewayType)
    def getTapeDriveType: ZIO[Any, AwsError, TapeDriveType] =
      AwsError.unwrapOptionField("tapeDriveType", tapeDriveType)
    def getMediumChangerType: ZIO[Any, AwsError, MediumChangerType] =
      AwsError.unwrapOptionField("mediumChangerType", mediumChangerType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ActivateGatewayRequest
  ) extends zio.aws.storagegateway.model.ActivateGatewayRequest.ReadOnly {
    override val activationKey: ActivationKey =
      zio.aws.storagegateway.model.primitives
        .ActivationKey(impl.activationKey())
    override val gatewayName: GatewayName =
      zio.aws.storagegateway.model.primitives.GatewayName(impl.gatewayName())
    override val gatewayTimezone: GatewayTimezone =
      zio.aws.storagegateway.model.primitives
        .GatewayTimezone(impl.gatewayTimezone())
    override val gatewayRegion: RegionId =
      zio.aws.storagegateway.model.primitives.RegionId(impl.gatewayRegion())
    override val gatewayType: Optional[GatewayType] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayType())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayType(value))
    override val tapeDriveType: Optional[TapeDriveType] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeDriveType())
      .map(value =>
        zio.aws.storagegateway.model.primitives.TapeDriveType(value)
      )
    override val mediumChangerType: Optional[MediumChangerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediumChangerType())
        .map(value =>
          zio.aws.storagegateway.model.primitives.MediumChangerType(value)
        )
    override val tags
        : Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ActivateGatewayRequest
  ): zio.aws.storagegateway.model.ActivateGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
