package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateSmbSecurityStrategyRequest(
    gatewayARN: GatewayARN,
    smbSecurityStrategy: zio.aws.storagegateway.model.SMBSecurityStrategy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyRequest = {
    import UpdateSmbSecurityStrategyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .smbSecurityStrategy(smbSecurityStrategy.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateSmbSecurityStrategyRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateSmbSecurityStrategyRequest
      .wrap(buildAwsValue())
}
object UpdateSmbSecurityStrategyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateSmbSecurityStrategyRequest =
      zio.aws.storagegateway.model
        .UpdateSmbSecurityStrategyRequest(gatewayARN, smbSecurityStrategy)
    def gatewayARN: GatewayARN
    def smbSecurityStrategy: zio.aws.storagegateway.model.SMBSecurityStrategy
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getSmbSecurityStrategy
        : ZIO[Any, Nothing, zio.aws.storagegateway.model.SMBSecurityStrategy] =
      ZIO.succeed(smbSecurityStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyRequest
  ) extends zio.aws.storagegateway.model.UpdateSmbSecurityStrategyRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val smbSecurityStrategy
        : zio.aws.storagegateway.model.SMBSecurityStrategy =
      zio.aws.storagegateway.model.SMBSecurityStrategy
        .wrap(impl.smbSecurityStrategy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyRequest
  ): zio.aws.storagegateway.model.UpdateSmbSecurityStrategyRequest.ReadOnly =
    new Wrapper(impl)
}
