package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateSmbLocalGroupsRequest(
    gatewayARN: GatewayARN,
    smbLocalGroups: zio.aws.storagegateway.model.SMBLocalGroups
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsRequest = {
    import UpdateSmbLocalGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .smbLocalGroups(smbLocalGroups.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateSmbLocalGroupsRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateSmbLocalGroupsRequest
      .wrap(buildAwsValue())
}
object UpdateSmbLocalGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.UpdateSmbLocalGroupsRequest =
      zio.aws.storagegateway.model
        .UpdateSmbLocalGroupsRequest(gatewayARN, smbLocalGroups.asEditable)
    def gatewayARN: GatewayARN
    def smbLocalGroups: zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getSmbLocalGroups: ZIO[
      Any,
      Nothing,
      zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly
    ] = ZIO.succeed(smbLocalGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsRequest
  ) extends zio.aws.storagegateway.model.UpdateSmbLocalGroupsRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val smbLocalGroups
        : zio.aws.storagegateway.model.SMBLocalGroups.ReadOnly =
      zio.aws.storagegateway.model.SMBLocalGroups.wrap(impl.smbLocalGroups())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsRequest
  ): zio.aws.storagegateway.model.UpdateSmbLocalGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
