package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{DiskId, GatewayARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeWorkingStorageResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    diskIds: Optional[Iterable[DiskId]] = Optional.Absent,
    workingStorageUsedInBytes: Optional[Long] = Optional.Absent,
    workingStorageAllocatedInBytes: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageResponse = {
    import DescribeWorkingStorageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        diskIds.map(value =>
          value.map { item =>
            DiskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.diskIds)
      .optionallyWith(
        workingStorageUsedInBytes.map(value => value: java.lang.Long)
      )(_.workingStorageUsedInBytes)
      .optionallyWith(
        workingStorageAllocatedInBytes.map(value => value: java.lang.Long)
      )(_.workingStorageAllocatedInBytes)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeWorkingStorageResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeWorkingStorageResponse
      .wrap(buildAwsValue())
}
object DescribeWorkingStorageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeWorkingStorageResponse =
      zio.aws.storagegateway.model.DescribeWorkingStorageResponse(
        gatewayARN.map(value => value),
        diskIds.map(value => value),
        workingStorageUsedInBytes.map(value => value),
        workingStorageAllocatedInBytes.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def diskIds: Optional[List[DiskId]]
    def workingStorageUsedInBytes: Optional[Long]
    def workingStorageAllocatedInBytes: Optional[Long]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getDiskIds: ZIO[Any, AwsError, List[DiskId]] =
      AwsError.unwrapOptionField("diskIds", diskIds)
    def getWorkingStorageUsedInBytes: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("workingStorageUsedInBytes", workingStorageUsedInBytes)
    def getWorkingStorageAllocatedInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "workingStorageAllocatedInBytes",
        workingStorageAllocatedInBytes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageResponse
  ) extends zio.aws.storagegateway.model.DescribeWorkingStorageResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val diskIds: Optional[List[DiskId]] = zio.aws.core.internal
      .optionalFromNullable(impl.diskIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.primitives.DiskId(item)
        }.toList
      )
    override val workingStorageUsedInBytes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workingStorageUsedInBytes())
        .map(value => value: Long)
    override val workingStorageAllocatedInBytes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workingStorageAllocatedInBytes())
        .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageResponse
  ): zio.aws.storagegateway.model.DescribeWorkingStorageResponse.ReadOnly =
    new Wrapper(impl)
}
