package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{TapeARN, GatewayARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelArchivalRequest(
    gatewayARN: GatewayARN,
    tapeARN: TapeARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CancelArchivalRequest = {
    import CancelArchivalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CancelArchivalRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .tapeARN(TapeARN.unwrap(tapeARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CancelArchivalRequest.ReadOnly =
    zio.aws.storagegateway.model.CancelArchivalRequest.wrap(buildAwsValue())
}
object CancelArchivalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CancelArchivalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CancelArchivalRequest =
      zio.aws.storagegateway.model.CancelArchivalRequest(gatewayARN, tapeARN)
    def gatewayARN: GatewayARN
    def tapeARN: TapeARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getTapeARN: ZIO[Any, Nothing, TapeARN] = ZIO.succeed(tapeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CancelArchivalRequest
  ) extends zio.aws.storagegateway.model.CancelArchivalRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val tapeARN: TapeARN =
      zio.aws.storagegateway.model.primitives.TapeARN(impl.tapeARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CancelArchivalRequest
  ): zio.aws.storagegateway.model.CancelArchivalRequest.ReadOnly = new Wrapper(
    impl
  )
}
