package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SetSmbGuestPasswordResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordResponse = {
    import SetSmbGuestPasswordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.SetSmbGuestPasswordResponse.ReadOnly =
    zio.aws.storagegateway.model.SetSmbGuestPasswordResponse
      .wrap(buildAwsValue())
}
object SetSmbGuestPasswordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.SetSmbGuestPasswordResponse =
      zio.aws.storagegateway.model
        .SetSmbGuestPasswordResponse(gatewayARN.map(value => value))
    def gatewayARN: Optional[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordResponse
  ) extends zio.aws.storagegateway.model.SetSmbGuestPasswordResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordResponse
  ): zio.aws.storagegateway.model.SetSmbGuestPasswordResponse.ReadOnly =
    new Wrapper(impl)
}
