package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListLocalDisksRequest(gatewayARN: GatewayARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListLocalDisksRequest = {
    import ListLocalDisksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListLocalDisksRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListLocalDisksRequest.ReadOnly =
    zio.aws.storagegateway.model.ListLocalDisksRequest.wrap(buildAwsValue())
}
object ListLocalDisksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListLocalDisksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListLocalDisksRequest =
      zio.aws.storagegateway.model.ListLocalDisksRequest(gatewayARN)
    def gatewayARN: GatewayARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListLocalDisksRequest
  ) extends zio.aws.storagegateway.model.ListLocalDisksRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListLocalDisksRequest
  ): zio.aws.storagegateway.model.ListLocalDisksRequest.ReadOnly = new Wrapper(
    impl
  )
}
