package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{PositiveIntObject, Marker}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListGatewaysRequest(
    marker: Optional[Marker] = Optional.Absent,
    limit: Optional[PositiveIntObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest = {
    import ListGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.ListGatewaysRequest.ReadOnly =
    zio.aws.storagegateway.model.ListGatewaysRequest.wrap(buildAwsValue())
}
object ListGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.ListGatewaysRequest =
      zio.aws.storagegateway.model.ListGatewaysRequest(
        marker.map(value => value),
        limit.map(value => value)
      )
    def marker: Optional[Marker]
    def limit: Optional[PositiveIntObject]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest
  ) extends zio.aws.storagegateway.model.ListGatewaysRequest.ReadOnly {
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
    override val limit: Optional[PositiveIntObject] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.storagegateway.model.primitives.PositiveIntObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest
  ): zio.aws.storagegateway.model.ListGatewaysRequest.ReadOnly = new Wrapper(
    impl
  )
}
