package zio.aws.storagegateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAutomaticTapeCreationPoliciesResponse(
    automaticTapeCreationPolicyInfos: Optional[
      Iterable[zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse = {
    import ListAutomaticTapeCreationPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse
      .builder()
      .optionallyWith(
        automaticTapeCreationPolicyInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.automaticTapeCreationPolicyInfos)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse.ReadOnly =
    zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse
      .wrap(buildAwsValue())
}
object ListAutomaticTapeCreationPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse =
      zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse(
        automaticTapeCreationPolicyInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def automaticTapeCreationPolicyInfos: Optional[List[
      zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo.ReadOnly
    ]]
    def getAutomaticTapeCreationPolicyInfos: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "automaticTapeCreationPolicyInfos",
      automaticTapeCreationPolicyInfos
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse
  ) extends zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse.ReadOnly {
    override val automaticTapeCreationPolicyInfos: Optional[List[
      zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticTapeCreationPolicyInfos())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.AutomaticTapeCreationPolicyInfo
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse
  ): zio.aws.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
