package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{VolumeARN, SnapshotId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSnapshotFromVolumeRecoveryPointResponse(
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    volumeARN: Optional[VolumeARN] = Optional.Absent,
    volumeRecoveryPointTime: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse = {
    import CreateSnapshotFromVolumeRecoveryPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse
      .builder()
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        volumeARN.map(value => VolumeARN.unwrap(value): java.lang.String)
      )(_.volumeARN)
      .optionallyWith(
        volumeRecoveryPointTime.map(value => value: java.lang.String)
      )(_.volumeRecoveryPointTime)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse.ReadOnly =
    zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse
      .wrap(buildAwsValue())
}
object CreateSnapshotFromVolumeRecoveryPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse =
      zio.aws.storagegateway.model
        .CreateSnapshotFromVolumeRecoveryPointResponse(
          snapshotId.map(value => value),
          volumeARN.map(value => value),
          volumeRecoveryPointTime.map(value => value)
        )
    def snapshotId: Optional[SnapshotId]
    def volumeARN: Optional[VolumeARN]
    def volumeRecoveryPointTime: Optional[String]
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeARN: ZIO[Any, AwsError, VolumeARN] =
      AwsError.unwrapOptionField("volumeARN", volumeARN)
    def getVolumeRecoveryPointTime: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("volumeRecoveryPointTime", volumeRecoveryPointTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse
  ) extends zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse.ReadOnly {
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.storagegateway.model.primitives.SnapshotId(value))
    override val volumeARN: Optional[VolumeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeARN())
      .map(value => zio.aws.storagegateway.model.primitives.VolumeARN(value))
    override val volumeRecoveryPointTime: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeRecoveryPointTime())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse
  ): zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse.ReadOnly =
    new Wrapper(impl)
}
