package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{IqnName, TargetARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateChapCredentialsResponse(
    targetARN: Optional[TargetARN] = Optional.Absent,
    initiatorName: Optional[IqnName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsResponse = {
    import UpdateChapCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsResponse
      .builder()
      .optionallyWith(
        targetARN.map(value => TargetARN.unwrap(value): java.lang.String)
      )(_.targetARN)
      .optionallyWith(
        initiatorName.map(value => IqnName.unwrap(value): java.lang.String)
      )(_.initiatorName)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateChapCredentialsResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateChapCredentialsResponse
      .wrap(buildAwsValue())
}
object UpdateChapCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.UpdateChapCredentialsResponse =
      zio.aws.storagegateway.model.UpdateChapCredentialsResponse(
        targetARN.map(value => value),
        initiatorName.map(value => value)
      )
    def targetARN: Optional[TargetARN]
    def initiatorName: Optional[IqnName]
    def getTargetARN: ZIO[Any, AwsError, TargetARN] =
      AwsError.unwrapOptionField("targetARN", targetARN)
    def getInitiatorName: ZIO[Any, AwsError, IqnName] =
      AwsError.unwrapOptionField("initiatorName", initiatorName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsResponse
  ) extends zio.aws.storagegateway.model.UpdateChapCredentialsResponse.ReadOnly {
    override val targetARN: Optional[TargetARN] = zio.aws.core.internal
      .optionalFromNullable(impl.targetARN())
      .map(value => zio.aws.storagegateway.model.primitives.TargetARN(value))
    override val initiatorName: Optional[IqnName] = zio.aws.core.internal
      .optionalFromNullable(impl.initiatorName())
      .map(value => zio.aws.storagegateway.model.primitives.IqnName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsResponse
  ): zio.aws.storagegateway.model.UpdateChapCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
