package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  DiskAttribute,
  DiskAllocationType,
  DiskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Disk(
    diskId: Optional[DiskId] = Optional.Absent,
    diskPath: Optional[String] = Optional.Absent,
    diskNode: Optional[String] = Optional.Absent,
    diskStatus: Optional[String] = Optional.Absent,
    diskSizeInBytes: Optional[Long] = Optional.Absent,
    diskAllocationType: Optional[DiskAllocationType] = Optional.Absent,
    diskAllocationResource: Optional[String] = Optional.Absent,
    diskAttributeList: Optional[Iterable[DiskAttribute]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.Disk = {
    import Disk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.Disk
      .builder()
      .optionallyWith(
        diskId.map(value => DiskId.unwrap(value): java.lang.String)
      )(_.diskId)
      .optionallyWith(diskPath.map(value => value: java.lang.String))(
        _.diskPath
      )
      .optionallyWith(diskNode.map(value => value: java.lang.String))(
        _.diskNode
      )
      .optionallyWith(diskStatus.map(value => value: java.lang.String))(
        _.diskStatus
      )
      .optionallyWith(diskSizeInBytes.map(value => value: java.lang.Long))(
        _.diskSizeInBytes
      )
      .optionallyWith(
        diskAllocationType.map(value =>
          DiskAllocationType.unwrap(value): java.lang.String
        )
      )(_.diskAllocationType)
      .optionallyWith(
        diskAllocationResource.map(value => value: java.lang.String)
      )(_.diskAllocationResource)
      .optionallyWith(
        diskAttributeList.map(value =>
          value.map { item =>
            DiskAttribute.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.diskAttributeList)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.Disk.ReadOnly =
    zio.aws.storagegateway.model.Disk.wrap(buildAwsValue())
}
object Disk {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.Disk
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.Disk =
      zio.aws.storagegateway.model.Disk(
        diskId.map(value => value),
        diskPath.map(value => value),
        diskNode.map(value => value),
        diskStatus.map(value => value),
        diskSizeInBytes.map(value => value),
        diskAllocationType.map(value => value),
        diskAllocationResource.map(value => value),
        diskAttributeList.map(value => value)
      )
    def diskId: Optional[DiskId]
    def diskPath: Optional[String]
    def diskNode: Optional[String]
    def diskStatus: Optional[String]
    def diskSizeInBytes: Optional[Long]
    def diskAllocationType: Optional[DiskAllocationType]
    def diskAllocationResource: Optional[String]
    def diskAttributeList: Optional[List[DiskAttribute]]
    def getDiskId: ZIO[Any, AwsError, DiskId] =
      AwsError.unwrapOptionField("diskId", diskId)
    def getDiskPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("diskPath", diskPath)
    def getDiskNode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("diskNode", diskNode)
    def getDiskStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("diskStatus", diskStatus)
    def getDiskSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("diskSizeInBytes", diskSizeInBytes)
    def getDiskAllocationType: ZIO[Any, AwsError, DiskAllocationType] =
      AwsError.unwrapOptionField("diskAllocationType", diskAllocationType)
    def getDiskAllocationResource: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("diskAllocationResource", diskAllocationResource)
    def getDiskAttributeList: ZIO[Any, AwsError, List[DiskAttribute]] =
      AwsError.unwrapOptionField("diskAttributeList", diskAttributeList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.Disk
  ) extends zio.aws.storagegateway.model.Disk.ReadOnly {
    override val diskId: Optional[DiskId] = zio.aws.core.internal
      .optionalFromNullable(impl.diskId())
      .map(value => zio.aws.storagegateway.model.primitives.DiskId(value))
    override val diskPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.diskPath())
      .map(value => value: String)
    override val diskNode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.diskNode())
      .map(value => value: String)
    override val diskStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.diskStatus())
      .map(value => value: String)
    override val diskSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.diskSizeInBytes())
      .map(value => value: Long)
    override val diskAllocationType: Optional[DiskAllocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskAllocationType())
        .map(value =>
          zio.aws.storagegateway.model.primitives.DiskAllocationType(value)
        )
    override val diskAllocationResource: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskAllocationResource())
        .map(value => value: String)
    override val diskAttributeList: Optional[List[DiskAttribute]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskAttributeList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.primitives.DiskAttribute(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.Disk
  ): zio.aws.storagegateway.model.Disk.ReadOnly = new Wrapper(impl)
}
