package zio.aws.storagegateway.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  PoolId,
  Time,
  TapeSize,
  KMSKey,
  TapeARN,
  TapeBarcode,
  TapeArchiveStatus,
  GatewayARN,
  TapeUsage
}
import scala.jdk.CollectionConverters.*
final case class TapeArchive(
    tapeARN: Optional[TapeARN] = Optional.Absent,
    tapeBarcode: Optional[TapeBarcode] = Optional.Absent,
    tapeCreatedDate: Optional[Time] = Optional.Absent,
    tapeSizeInBytes: Optional[TapeSize] = Optional.Absent,
    completionTime: Optional[Time] = Optional.Absent,
    retrievedTo: Optional[GatewayARN] = Optional.Absent,
    tapeStatus: Optional[TapeArchiveStatus] = Optional.Absent,
    tapeUsedInBytes: Optional[TapeUsage] = Optional.Absent,
    kmsKey: Optional[KMSKey] = Optional.Absent,
    poolId: Optional[PoolId] = Optional.Absent,
    worm: Optional[Boolean] = Optional.Absent,
    retentionStartDate: Optional[Time] = Optional.Absent,
    poolEntryDate: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.TapeArchive = {
    import TapeArchive.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.TapeArchive
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .optionallyWith(
        tapeBarcode.map(value => TapeBarcode.unwrap(value): java.lang.String)
      )(_.tapeBarcode)
      .optionallyWith(
        tapeCreatedDate.map(value => Time.unwrap(value): Instant)
      )(_.tapeCreatedDate)
      .optionallyWith(
        tapeSizeInBytes.map(value => TapeSize.unwrap(value): java.lang.Long)
      )(_.tapeSizeInBytes)
      .optionallyWith(completionTime.map(value => Time.unwrap(value): Instant))(
        _.completionTime
      )
      .optionallyWith(
        retrievedTo.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.retrievedTo)
      .optionallyWith(
        tapeStatus.map(value =>
          TapeArchiveStatus.unwrap(value): java.lang.String
        )
      )(_.tapeStatus)
      .optionallyWith(
        tapeUsedInBytes.map(value => TapeUsage.unwrap(value): java.lang.Long)
      )(_.tapeUsedInBytes)
      .optionallyWith(
        kmsKey.map(value => KMSKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        poolId.map(value => PoolId.unwrap(value): java.lang.String)
      )(_.poolId)
      .optionallyWith(worm.map(value => value: java.lang.Boolean))(_.worm)
      .optionallyWith(
        retentionStartDate.map(value => Time.unwrap(value): Instant)
      )(_.retentionStartDate)
      .optionallyWith(poolEntryDate.map(value => Time.unwrap(value): Instant))(
        _.poolEntryDate
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.TapeArchive.ReadOnly =
    zio.aws.storagegateway.model.TapeArchive.wrap(buildAwsValue())
}
object TapeArchive {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.TapeArchive
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.TapeArchive =
      zio.aws.storagegateway.model.TapeArchive(
        tapeARN.map(value => value),
        tapeBarcode.map(value => value),
        tapeCreatedDate.map(value => value),
        tapeSizeInBytes.map(value => value),
        completionTime.map(value => value),
        retrievedTo.map(value => value),
        tapeStatus.map(value => value),
        tapeUsedInBytes.map(value => value),
        kmsKey.map(value => value),
        poolId.map(value => value),
        worm.map(value => value),
        retentionStartDate.map(value => value),
        poolEntryDate.map(value => value)
      )
    def tapeARN: Optional[TapeARN]
    def tapeBarcode: Optional[TapeBarcode]
    def tapeCreatedDate: Optional[Time]
    def tapeSizeInBytes: Optional[TapeSize]
    def completionTime: Optional[Time]
    def retrievedTo: Optional[GatewayARN]
    def tapeStatus: Optional[TapeArchiveStatus]
    def tapeUsedInBytes: Optional[TapeUsage]
    def kmsKey: Optional[KMSKey]
    def poolId: Optional[PoolId]
    def worm: Optional[Boolean]
    def retentionStartDate: Optional[Time]
    def poolEntryDate: Optional[Time]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
    def getTapeBarcode: ZIO[Any, AwsError, TapeBarcode] =
      AwsError.unwrapOptionField("tapeBarcode", tapeBarcode)
    def getTapeCreatedDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("tapeCreatedDate", tapeCreatedDate)
    def getTapeSizeInBytes: ZIO[Any, AwsError, TapeSize] =
      AwsError.unwrapOptionField("tapeSizeInBytes", tapeSizeInBytes)
    def getCompletionTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getRetrievedTo: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("retrievedTo", retrievedTo)
    def getTapeStatus: ZIO[Any, AwsError, TapeArchiveStatus] =
      AwsError.unwrapOptionField("tapeStatus", tapeStatus)
    def getTapeUsedInBytes: ZIO[Any, AwsError, TapeUsage] =
      AwsError.unwrapOptionField("tapeUsedInBytes", tapeUsedInBytes)
    def getKmsKey: ZIO[Any, AwsError, KMSKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getPoolId: ZIO[Any, AwsError, PoolId] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getWorm: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("worm", worm)
    def getRetentionStartDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("retentionStartDate", retentionStartDate)
    def getPoolEntryDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("poolEntryDate", poolEntryDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeArchive
  ) extends zio.aws.storagegateway.model.TapeArchive.ReadOnly {
    override val tapeARN: Optional[TapeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
    override val tapeBarcode: Optional[TapeBarcode] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeBarcode())
      .map(value => zio.aws.storagegateway.model.primitives.TapeBarcode(value))
    override val tapeCreatedDate: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeCreatedDate())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
    override val tapeSizeInBytes: Optional[TapeSize] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeSizeInBytes())
      .map(value => zio.aws.storagegateway.model.primitives.TapeSize(value))
    override val completionTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.completionTime())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
    override val retrievedTo: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.retrievedTo())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val tapeStatus: Optional[TapeArchiveStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeStatus())
      .map(value =>
        zio.aws.storagegateway.model.primitives.TapeArchiveStatus(value)
      )
    override val tapeUsedInBytes: Optional[TapeUsage] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeUsedInBytes())
      .map(value => zio.aws.storagegateway.model.primitives.TapeUsage(value))
    override val kmsKey: Optional[KMSKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.storagegateway.model.primitives.KMSKey(value))
    override val poolId: Optional[PoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.poolId())
      .map(value => zio.aws.storagegateway.model.primitives.PoolId(value))
    override val worm: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.worm())
      .map(value => value: Boolean)
    override val retentionStartDate: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionStartDate())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
    override val poolEntryDate: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.poolEntryDate())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeArchive
  ): zio.aws.storagegateway.model.TapeArchive.ReadOnly = new Wrapper(impl)
}
