package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListVolumeRecoveryPointsResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    volumeRecoveryPointInfos: Optional[
      Iterable[zio.aws.storagegateway.model.VolumeRecoveryPointInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsResponse = {
    import ListVolumeRecoveryPointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        volumeRecoveryPointInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumeRecoveryPointInfos)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse.ReadOnly =
    zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse
      .wrap(buildAwsValue())
}
object ListVolumeRecoveryPointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse =
      zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse(
        gatewayARN.map(value => value),
        volumeRecoveryPointInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gatewayARN: Optional[GatewayARN]
    def volumeRecoveryPointInfos: Optional[
      List[zio.aws.storagegateway.model.VolumeRecoveryPointInfo.ReadOnly]
    ]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getVolumeRecoveryPointInfos: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.VolumeRecoveryPointInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "volumeRecoveryPointInfos",
      volumeRecoveryPointInfos
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsResponse
  ) extends zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val volumeRecoveryPointInfos: Optional[
      List[zio.aws.storagegateway.model.VolumeRecoveryPointInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeRecoveryPointInfos())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.VolumeRecoveryPointInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsResponse
  ): zio.aws.storagegateway.model.ListVolumeRecoveryPointsResponse.ReadOnly =
    new Wrapper(impl)
}
