package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeWorkingStorageRequest(gatewayARN: GatewayARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageRequest = {
    import DescribeWorkingStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeWorkingStorageRequest.ReadOnly =
    zio.aws.storagegateway.model.DescribeWorkingStorageRequest
      .wrap(buildAwsValue())
}
object DescribeWorkingStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeWorkingStorageRequest =
      zio.aws.storagegateway.model.DescribeWorkingStorageRequest(gatewayARN)
    def gatewayARN: GatewayARN
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageRequest
  ) extends zio.aws.storagegateway.model.DescribeWorkingStorageRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageRequest
  ): zio.aws.storagegateway.model.DescribeWorkingStorageRequest.ReadOnly =
    new Wrapper(impl)
}
