package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileSystemAssociationARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateFileSystemResponse(
    fileSystemAssociationARN: Optional[FileSystemAssociationARN] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse = {
    import AssociateFileSystemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse
      .builder()
      .optionallyWith(
        fileSystemAssociationARN.map(value =>
          FileSystemAssociationARN.unwrap(value): java.lang.String
        )
      )(_.fileSystemAssociationARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly =
    zio.aws.storagegateway.model.AssociateFileSystemResponse
      .wrap(buildAwsValue())
}
object AssociateFileSystemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AssociateFileSystemResponse =
      zio.aws.storagegateway.model.AssociateFileSystemResponse(
        fileSystemAssociationARN.map(value => value)
      )
    def fileSystemAssociationARN: Optional[FileSystemAssociationARN]
    def getFileSystemAssociationARN
        : ZIO[Any, AwsError, FileSystemAssociationARN] = AwsError
      .unwrapOptionField("fileSystemAssociationARN", fileSystemAssociationARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse
  ) extends zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly {
    override val fileSystemAssociationARN: Optional[FileSystemAssociationARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemAssociationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives
            .FileSystemAssociationARN(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse
  ): zio.aws.storagegateway.model.AssociateFileSystemResponse.ReadOnly =
    new Wrapper(impl)
}
