package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.PoolARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteTapePoolResponse(
    poolARN: Optional[PoolARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse = {
    import DeleteTapePoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse
      .builder()
      .optionallyWith(
        poolARN.map(value => PoolARN.unwrap(value): java.lang.String)
      )(_.poolARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly =
    zio.aws.storagegateway.model.DeleteTapePoolResponse.wrap(buildAwsValue())
}
object DeleteTapePoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DeleteTapePoolResponse =
      zio.aws.storagegateway.model
        .DeleteTapePoolResponse(poolARN.map(value => value))
    def poolARN: Optional[PoolARN]
    def getPoolARN: ZIO[Any, AwsError, PoolARN] =
      AwsError.unwrapOptionField("poolARN", poolARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse
  ) extends zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly {
    override val poolARN: Optional[PoolARN] = zio.aws.core.internal
      .optionalFromNullable(impl.poolARN())
      .map(value => zio.aws.storagegateway.model.primitives.PoolARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse
  ): zio.aws.storagegateway.model.DeleteTapePoolResponse.ReadOnly = new Wrapper(
    impl
  )
}
