package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  Ec2InstanceId,
  GatewayId,
  Ec2InstanceRegion,
  SoftwareUpdatesEndDate,
  GatewayType,
  GatewayState,
  DeprecationDate,
  EndpointType,
  CloudWatchLogGroupARN,
  GatewayARN,
  HostEnvironmentId,
  GatewayTimezone,
  NextUpdateAvailabilityDate,
  LastSoftwareUpdate
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeGatewayInformationResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    gatewayId: Optional[GatewayId] = Optional.Absent,
    gatewayName: Optional[String] = Optional.Absent,
    gatewayTimezone: Optional[GatewayTimezone] = Optional.Absent,
    gatewayState: Optional[GatewayState] = Optional.Absent,
    gatewayNetworkInterfaces: Optional[
      Iterable[zio.aws.storagegateway.model.NetworkInterface]
    ] = Optional.Absent,
    gatewayType: Optional[GatewayType] = Optional.Absent,
    nextUpdateAvailabilityDate: Optional[NextUpdateAvailabilityDate] =
      Optional.Absent,
    lastSoftwareUpdate: Optional[LastSoftwareUpdate] = Optional.Absent,
    ec2InstanceId: Optional[Ec2InstanceId] = Optional.Absent,
    ec2InstanceRegion: Optional[Ec2InstanceRegion] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.storagegateway.model.Tag]] =
      Optional.Absent,
    vpcEndpoint: Optional[String] = Optional.Absent,
    cloudWatchLogGroupARN: Optional[CloudWatchLogGroupARN] = Optional.Absent,
    hostEnvironment: Optional[zio.aws.storagegateway.model.HostEnvironment] =
      Optional.Absent,
    endpointType: Optional[EndpointType] = Optional.Absent,
    softwareUpdatesEndDate: Optional[SoftwareUpdatesEndDate] = Optional.Absent,
    deprecationDate: Optional[DeprecationDate] = Optional.Absent,
    gatewayCapacity: Optional[zio.aws.storagegateway.model.GatewayCapacity] =
      Optional.Absent,
    supportedGatewayCapacities: Optional[
      Iterable[zio.aws.storagegateway.model.GatewayCapacity]
    ] = Optional.Absent,
    hostEnvironmentId: Optional[HostEnvironmentId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse = {
    import DescribeGatewayInformationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        gatewayId.map(value => GatewayId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(gatewayName.map(value => value: java.lang.String))(
        _.gatewayName
      )
      .optionallyWith(
        gatewayTimezone.map(value =>
          GatewayTimezone.unwrap(value): java.lang.String
        )
      )(_.gatewayTimezone)
      .optionallyWith(
        gatewayState.map(value => GatewayState.unwrap(value): java.lang.String)
      )(_.gatewayState)
      .optionallyWith(
        gatewayNetworkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gatewayNetworkInterfaces)
      .optionallyWith(
        gatewayType.map(value => GatewayType.unwrap(value): java.lang.String)
      )(_.gatewayType)
      .optionallyWith(
        nextUpdateAvailabilityDate.map(value =>
          NextUpdateAvailabilityDate.unwrap(value): java.lang.String
        )
      )(_.nextUpdateAvailabilityDate)
      .optionallyWith(
        lastSoftwareUpdate.map(value =>
          LastSoftwareUpdate.unwrap(value): java.lang.String
        )
      )(_.lastSoftwareUpdate)
      .optionallyWith(
        ec2InstanceId.map(value =>
          Ec2InstanceId.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceId)
      .optionallyWith(
        ec2InstanceRegion.map(value =>
          Ec2InstanceRegion.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceRegion)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcEndpoint.map(value => value: java.lang.String))(
        _.vpcEndpoint
      )
      .optionallyWith(
        cloudWatchLogGroupARN.map(value =>
          CloudWatchLogGroupARN.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupARN)
      .optionallyWith(hostEnvironment.map(value => value.unwrap))(
        _.hostEnvironment
      )
      .optionallyWith(
        endpointType.map(value => EndpointType.unwrap(value): java.lang.String)
      )(_.endpointType)
      .optionallyWith(
        softwareUpdatesEndDate.map(value =>
          SoftwareUpdatesEndDate.unwrap(value): java.lang.String
        )
      )(_.softwareUpdatesEndDate)
      .optionallyWith(
        deprecationDate.map(value =>
          DeprecationDate.unwrap(value): java.lang.String
        )
      )(_.deprecationDate)
      .optionallyWith(gatewayCapacity.map(value => value.unwrap))(
        _.gatewayCapacity
      )
      .optionallyWith(
        supportedGatewayCapacities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedGatewayCapacitiesWithStrings)
      .optionallyWith(
        hostEnvironmentId.map(value =>
          HostEnvironmentId.unwrap(value): java.lang.String
        )
      )(_.hostEnvironmentId)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeGatewayInformationResponse
      .wrap(buildAwsValue())
}
object DescribeGatewayInformationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeGatewayInformationResponse =
      zio.aws.storagegateway.model.DescribeGatewayInformationResponse(
        gatewayARN.map(value => value),
        gatewayId.map(value => value),
        gatewayName.map(value => value),
        gatewayTimezone.map(value => value),
        gatewayState.map(value => value),
        gatewayNetworkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gatewayType.map(value => value),
        nextUpdateAvailabilityDate.map(value => value),
        lastSoftwareUpdate.map(value => value),
        ec2InstanceId.map(value => value),
        ec2InstanceRegion.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcEndpoint.map(value => value),
        cloudWatchLogGroupARN.map(value => value),
        hostEnvironment.map(value => value),
        endpointType.map(value => value),
        softwareUpdatesEndDate.map(value => value),
        deprecationDate.map(value => value),
        gatewayCapacity.map(value => value),
        supportedGatewayCapacities.map(value => value),
        hostEnvironmentId.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def gatewayId: Optional[GatewayId]
    def gatewayName: Optional[String]
    def gatewayTimezone: Optional[GatewayTimezone]
    def gatewayState: Optional[GatewayState]
    def gatewayNetworkInterfaces
        : Optional[List[zio.aws.storagegateway.model.NetworkInterface.ReadOnly]]
    def gatewayType: Optional[GatewayType]
    def nextUpdateAvailabilityDate: Optional[NextUpdateAvailabilityDate]
    def lastSoftwareUpdate: Optional[LastSoftwareUpdate]
    def ec2InstanceId: Optional[Ec2InstanceId]
    def ec2InstanceRegion: Optional[Ec2InstanceRegion]
    def tags: Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def vpcEndpoint: Optional[String]
    def cloudWatchLogGroupARN: Optional[CloudWatchLogGroupARN]
    def hostEnvironment: Optional[zio.aws.storagegateway.model.HostEnvironment]
    def endpointType: Optional[EndpointType]
    def softwareUpdatesEndDate: Optional[SoftwareUpdatesEndDate]
    def deprecationDate: Optional[DeprecationDate]
    def gatewayCapacity: Optional[zio.aws.storagegateway.model.GatewayCapacity]
    def supportedGatewayCapacities
        : Optional[List[zio.aws.storagegateway.model.GatewayCapacity]]
    def hostEnvironmentId: Optional[HostEnvironmentId]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getGatewayId: ZIO[Any, AwsError, GatewayId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getGatewayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayName", gatewayName)
    def getGatewayTimezone: ZIO[Any, AwsError, GatewayTimezone] =
      AwsError.unwrapOptionField("gatewayTimezone", gatewayTimezone)
    def getGatewayState: ZIO[Any, AwsError, GatewayState] =
      AwsError.unwrapOptionField("gatewayState", gatewayState)
    def getGatewayNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "gatewayNetworkInterfaces",
      gatewayNetworkInterfaces
    )
    def getGatewayType: ZIO[Any, AwsError, GatewayType] =
      AwsError.unwrapOptionField("gatewayType", gatewayType)
    def getNextUpdateAvailabilityDate
        : ZIO[Any, AwsError, NextUpdateAvailabilityDate] =
      AwsError.unwrapOptionField(
        "nextUpdateAvailabilityDate",
        nextUpdateAvailabilityDate
      )
    def getLastSoftwareUpdate: ZIO[Any, AwsError, LastSoftwareUpdate] =
      AwsError.unwrapOptionField("lastSoftwareUpdate", lastSoftwareUpdate)
    def getEc2InstanceId: ZIO[Any, AwsError, Ec2InstanceId] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getEc2InstanceRegion: ZIO[Any, AwsError, Ec2InstanceRegion] =
      AwsError.unwrapOptionField("ec2InstanceRegion", ec2InstanceRegion)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpoint", vpcEndpoint)
    def getCloudWatchLogGroupARN: ZIO[Any, AwsError, CloudWatchLogGroupARN] =
      AwsError.unwrapOptionField("cloudWatchLogGroupARN", cloudWatchLogGroupARN)
    def getHostEnvironment
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.HostEnvironment] =
      AwsError.unwrapOptionField("hostEnvironment", hostEnvironment)
    def getEndpointType: ZIO[Any, AwsError, EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getSoftwareUpdatesEndDate: ZIO[Any, AwsError, SoftwareUpdatesEndDate] =
      AwsError.unwrapOptionField(
        "softwareUpdatesEndDate",
        softwareUpdatesEndDate
      )
    def getDeprecationDate: ZIO[Any, AwsError, DeprecationDate] =
      AwsError.unwrapOptionField("deprecationDate", deprecationDate)
    def getGatewayCapacity
        : ZIO[Any, AwsError, zio.aws.storagegateway.model.GatewayCapacity] =
      AwsError.unwrapOptionField("gatewayCapacity", gatewayCapacity)
    def getSupportedGatewayCapacities: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.GatewayCapacity
    ]] = AwsError.unwrapOptionField(
      "supportedGatewayCapacities",
      supportedGatewayCapacities
    )
    def getHostEnvironmentId: ZIO[Any, AwsError, HostEnvironmentId] =
      AwsError.unwrapOptionField("hostEnvironmentId", hostEnvironmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse
  ) extends zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val gatewayId: Optional[GatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayId(value))
    override val gatewayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayName())
      .map(value => value: String)
    override val gatewayTimezone: Optional[GatewayTimezone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayTimezone())
        .map(value =>
          zio.aws.storagegateway.model.primitives.GatewayTimezone(value)
        )
    override val gatewayState: Optional[GatewayState] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayState())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayState(value))
    override val gatewayNetworkInterfaces: Optional[
      List[zio.aws.storagegateway.model.NetworkInterface.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayNetworkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.storagegateway.model.NetworkInterface.wrap(item)
        }.toList
      )
    override val gatewayType: Optional[GatewayType] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayType())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayType(value))
    override val nextUpdateAvailabilityDate
        : Optional[NextUpdateAvailabilityDate] = zio.aws.core.internal
      .optionalFromNullable(impl.nextUpdateAvailabilityDate())
      .map(value =>
        zio.aws.storagegateway.model.primitives
          .NextUpdateAvailabilityDate(value)
      )
    override val lastSoftwareUpdate: Optional[LastSoftwareUpdate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSoftwareUpdate())
        .map(value =>
          zio.aws.storagegateway.model.primitives.LastSoftwareUpdate(value)
        )
    override val ec2InstanceId: Optional[Ec2InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceId())
      .map(value =>
        zio.aws.storagegateway.model.primitives.Ec2InstanceId(value)
      )
    override val ec2InstanceRegion: Optional[Ec2InstanceRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceRegion())
        .map(value =>
          zio.aws.storagegateway.model.primitives.Ec2InstanceRegion(value)
        )
    override val tags
        : Optional[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
    override val vpcEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpoint())
      .map(value => value: String)
    override val cloudWatchLogGroupARN: Optional[CloudWatchLogGroupARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives.CloudWatchLogGroupARN(value)
        )
    override val hostEnvironment
        : Optional[zio.aws.storagegateway.model.HostEnvironment] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostEnvironment())
        .map(value => zio.aws.storagegateway.model.HostEnvironment.wrap(value))
    override val endpointType: Optional[EndpointType] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointType())
      .map(value => zio.aws.storagegateway.model.primitives.EndpointType(value))
    override val softwareUpdatesEndDate: Optional[SoftwareUpdatesEndDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.softwareUpdatesEndDate())
        .map(value =>
          zio.aws.storagegateway.model.primitives.SoftwareUpdatesEndDate(value)
        )
    override val deprecationDate: Optional[DeprecationDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deprecationDate())
        .map(value =>
          zio.aws.storagegateway.model.primitives.DeprecationDate(value)
        )
    override val gatewayCapacity
        : Optional[zio.aws.storagegateway.model.GatewayCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayCapacity())
        .map(value => zio.aws.storagegateway.model.GatewayCapacity.wrap(value))
    override val supportedGatewayCapacities
        : Optional[List[zio.aws.storagegateway.model.GatewayCapacity]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedGatewayCapacities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.GatewayCapacity.wrap(item)
          }.toList
        )
    override val hostEnvironmentId: Optional[HostEnvironmentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostEnvironmentId())
        .map(value =>
          zio.aws.storagegateway.model.primitives.HostEnvironmentId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse
  ): zio.aws.storagegateway.model.DescribeGatewayInformationResponse.ReadOnly =
    new Wrapper(impl)
}
