package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  HourOfDay,
  DayOfWeek,
  GatewayARN,
  MinuteOfHour,
  DayOfMonth
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateMaintenanceStartTimeRequest(
    gatewayARN: GatewayARN,
    hourOfDay: HourOfDay,
    minuteOfHour: MinuteOfHour,
    dayOfWeek: Optional[DayOfWeek] = Optional.Absent,
    dayOfMonth: Optional[DayOfMonth] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeRequest = {
    import UpdateMaintenanceStartTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeRequest
      .builder()
      .gatewayARN(GatewayARN.unwrap(gatewayARN): java.lang.String)
      .hourOfDay(HourOfDay.unwrap(hourOfDay): Integer)
      .minuteOfHour(MinuteOfHour.unwrap(minuteOfHour): Integer)
      .optionallyWith(dayOfWeek.map(value => DayOfWeek.unwrap(value): Integer))(
        _.dayOfWeek
      )
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): Integer)
      )(_.dayOfMonth)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateMaintenanceStartTimeRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateMaintenanceStartTimeRequest
      .wrap(buildAwsValue())
}
object UpdateMaintenanceStartTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateMaintenanceStartTimeRequest =
      zio.aws.storagegateway.model.UpdateMaintenanceStartTimeRequest(
        gatewayARN,
        hourOfDay,
        minuteOfHour,
        dayOfWeek.map(value => value),
        dayOfMonth.map(value => value)
      )
    def gatewayARN: GatewayARN
    def hourOfDay: HourOfDay
    def minuteOfHour: MinuteOfHour
    def dayOfWeek: Optional[DayOfWeek]
    def dayOfMonth: Optional[DayOfMonth]
    def getGatewayARN: ZIO[Any, Nothing, GatewayARN] = ZIO.succeed(gatewayARN)
    def getHourOfDay: ZIO[Any, Nothing, HourOfDay] = ZIO.succeed(hourOfDay)
    def getMinuteOfHour: ZIO[Any, Nothing, MinuteOfHour] =
      ZIO.succeed(minuteOfHour)
    def getDayOfWeek: ZIO[Any, AwsError, DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeRequest
  ) extends zio.aws.storagegateway.model.UpdateMaintenanceStartTimeRequest.ReadOnly {
    override val gatewayARN: GatewayARN =
      zio.aws.storagegateway.model.primitives.GatewayARN(impl.gatewayARN())
    override val hourOfDay: HourOfDay =
      zio.aws.storagegateway.model.primitives.HourOfDay(impl.hourOfDay())
    override val minuteOfHour: MinuteOfHour =
      zio.aws.storagegateway.model.primitives.MinuteOfHour(impl.minuteOfHour())
    override val dayOfWeek: Optional[DayOfWeek] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfWeek())
      .map(value => zio.aws.storagegateway.model.primitives.DayOfWeek(value))
    override val dayOfMonth: Optional[DayOfMonth] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfMonth())
      .map(value => zio.aws.storagegateway.model.primitives.DayOfMonth(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeRequest
  ): zio.aws.storagegateway.model.UpdateMaintenanceStartTimeRequest.ReadOnly =
    new Wrapper(impl)
}
