package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{TagKey, ResourceARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RemoveTagsFromResourceRequest(
    resourceARN: ResourceARN,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceRequest = {
    import RemoveTagsFromResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceRequest
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.RemoveTagsFromResourceRequest.ReadOnly =
    zio.aws.storagegateway.model.RemoveTagsFromResourceRequest
      .wrap(buildAwsValue())
}
object RemoveTagsFromResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.RemoveTagsFromResourceRequest =
      zio.aws.storagegateway.model
        .RemoveTagsFromResourceRequest(resourceARN, tagKeys)
    def resourceARN: ResourceARN
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceRequest
  ) extends zio.aws.storagegateway.model.RemoveTagsFromResourceRequest.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.storagegateway.model.primitives.ResourceARN(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.storagegateway.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceRequest
  ): zio.aws.storagegateway.model.RemoveTagsFromResourceRequest.ReadOnly =
    new Wrapper(impl)
}
