package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{
  AuditDestinationARN,
  DomainUserPassword,
  DomainUserName,
  FileSystemAssociationARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFileSystemAssociationRequest(
    fileSystemAssociationARN: FileSystemAssociationARN,
    userName: Optional[DomainUserName] = Optional.Absent,
    password: Optional[DomainUserPassword] = Optional.Absent,
    auditDestinationARN: Optional[AuditDestinationARN] = Optional.Absent,
    cacheAttributes: Optional[zio.aws.storagegateway.model.CacheAttributes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest = {
    import UpdateFileSystemAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest
      .builder()
      .fileSystemAssociationARN(
        FileSystemAssociationARN.unwrap(
          fileSystemAssociationARN
        ): java.lang.String
      )
      .optionallyWith(
        userName.map(value => DomainUserName.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        password.map(value =>
          DomainUserPassword.unwrap(value): java.lang.String
        )
      )(_.password)
      .optionallyWith(
        auditDestinationARN.map(value =>
          AuditDestinationARN.unwrap(value): java.lang.String
        )
      )(_.auditDestinationARN)
      .optionallyWith(cacheAttributes.map(value => value.buildAwsValue()))(
        _.cacheAttributes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest.ReadOnly =
    zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateFileSystemAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest =
      zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest(
        fileSystemAssociationARN,
        userName.map(value => value),
        password.map(value => value),
        auditDestinationARN.map(value => value),
        cacheAttributes.map(value => value.asEditable)
      )
    def fileSystemAssociationARN: FileSystemAssociationARN
    def userName: Optional[DomainUserName]
    def password: Optional[DomainUserPassword]
    def auditDestinationARN: Optional[AuditDestinationARN]
    def cacheAttributes
        : Optional[zio.aws.storagegateway.model.CacheAttributes.ReadOnly]
    def getFileSystemAssociationARN
        : ZIO[Any, Nothing, FileSystemAssociationARN] =
      ZIO.succeed(fileSystemAssociationARN)
    def getUserName: ZIO[Any, AwsError, DomainUserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getPassword: ZIO[Any, AwsError, DomainUserPassword] =
      AwsError.unwrapOptionField("password", password)
    def getAuditDestinationARN: ZIO[Any, AwsError, AuditDestinationARN] =
      AwsError.unwrapOptionField("auditDestinationARN", auditDestinationARN)
    def getCacheAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.CacheAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("cacheAttributes", cacheAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest
  ) extends zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest.ReadOnly {
    override val fileSystemAssociationARN: FileSystemAssociationARN =
      zio.aws.storagegateway.model.primitives
        .FileSystemAssociationARN(impl.fileSystemAssociationARN())
    override val userName: Optional[DomainUserName] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value =>
        zio.aws.storagegateway.model.primitives.DomainUserName(value)
      )
    override val password: Optional[DomainUserPassword] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.storagegateway.model.primitives.DomainUserPassword(value)
      )
    override val auditDestinationARN: Optional[AuditDestinationARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditDestinationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives.AuditDestinationARN(value)
        )
    override val cacheAttributes
        : Optional[zio.aws.storagegateway.model.CacheAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheAttributes())
        .map(value => zio.aws.storagegateway.model.CacheAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest
  ): zio.aws.storagegateway.model.UpdateFileSystemAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
