package zio.aws.storagegateway.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  PoolId,
  Time,
  TapeSize,
  TapeARN,
  TapeBarcode,
  GatewayARN,
  TapeStatus
}
import scala.jdk.CollectionConverters.*
final case class TapeInfo(
    tapeARN: Optional[TapeARN] = Optional.Absent,
    tapeBarcode: Optional[TapeBarcode] = Optional.Absent,
    tapeSizeInBytes: Optional[TapeSize] = Optional.Absent,
    tapeStatus: Optional[TapeStatus] = Optional.Absent,
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    poolId: Optional[PoolId] = Optional.Absent,
    retentionStartDate: Optional[Time] = Optional.Absent,
    poolEntryDate: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.TapeInfo = {
    import TapeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.TapeInfo
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .optionallyWith(
        tapeBarcode.map(value => TapeBarcode.unwrap(value): java.lang.String)
      )(_.tapeBarcode)
      .optionallyWith(
        tapeSizeInBytes.map(value => TapeSize.unwrap(value): java.lang.Long)
      )(_.tapeSizeInBytes)
      .optionallyWith(
        tapeStatus.map(value => TapeStatus.unwrap(value): java.lang.String)
      )(_.tapeStatus)
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(
        poolId.map(value => PoolId.unwrap(value): java.lang.String)
      )(_.poolId)
      .optionallyWith(
        retentionStartDate.map(value => Time.unwrap(value): Instant)
      )(_.retentionStartDate)
      .optionallyWith(poolEntryDate.map(value => Time.unwrap(value): Instant))(
        _.poolEntryDate
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.TapeInfo.ReadOnly =
    zio.aws.storagegateway.model.TapeInfo.wrap(buildAwsValue())
}
object TapeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.TapeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.TapeInfo =
      zio.aws.storagegateway.model.TapeInfo(
        tapeARN.map(value => value),
        tapeBarcode.map(value => value),
        tapeSizeInBytes.map(value => value),
        tapeStatus.map(value => value),
        gatewayARN.map(value => value),
        poolId.map(value => value),
        retentionStartDate.map(value => value),
        poolEntryDate.map(value => value)
      )
    def tapeARN: Optional[TapeARN]
    def tapeBarcode: Optional[TapeBarcode]
    def tapeSizeInBytes: Optional[TapeSize]
    def tapeStatus: Optional[TapeStatus]
    def gatewayARN: Optional[GatewayARN]
    def poolId: Optional[PoolId]
    def retentionStartDate: Optional[Time]
    def poolEntryDate: Optional[Time]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
    def getTapeBarcode: ZIO[Any, AwsError, TapeBarcode] =
      AwsError.unwrapOptionField("tapeBarcode", tapeBarcode)
    def getTapeSizeInBytes: ZIO[Any, AwsError, TapeSize] =
      AwsError.unwrapOptionField("tapeSizeInBytes", tapeSizeInBytes)
    def getTapeStatus: ZIO[Any, AwsError, TapeStatus] =
      AwsError.unwrapOptionField("tapeStatus", tapeStatus)
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getPoolId: ZIO[Any, AwsError, PoolId] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getRetentionStartDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("retentionStartDate", retentionStartDate)
    def getPoolEntryDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("poolEntryDate", poolEntryDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeInfo
  ) extends zio.aws.storagegateway.model.TapeInfo.ReadOnly {
    override val tapeARN: Optional[TapeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
    override val tapeBarcode: Optional[TapeBarcode] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeBarcode())
      .map(value => zio.aws.storagegateway.model.primitives.TapeBarcode(value))
    override val tapeSizeInBytes: Optional[TapeSize] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeSizeInBytes())
      .map(value => zio.aws.storagegateway.model.primitives.TapeSize(value))
    override val tapeStatus: Optional[TapeStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeStatus())
      .map(value => zio.aws.storagegateway.model.primitives.TapeStatus(value))
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val poolId: Optional[PoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.poolId())
      .map(value => zio.aws.storagegateway.model.primitives.PoolId(value))
    override val retentionStartDate: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionStartDate())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
    override val poolEntryDate: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.poolEntryDate())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.TapeInfo
  ): zio.aws.storagegateway.model.TapeInfo.ReadOnly = new Wrapper(impl)
}
