package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VTLDeviceARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVtlDeviceTypeResponse(
    vtlDeviceARN: Optional[VTLDeviceARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeResponse = {
    import UpdateVtlDeviceTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeResponse
      .builder()
      .optionallyWith(
        vtlDeviceARN.map(value => VTLDeviceARN.unwrap(value): java.lang.String)
      )(_.vtlDeviceARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse
      .wrap(buildAwsValue())
}
object UpdateVtlDeviceTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse =
      zio.aws.storagegateway.model
        .UpdateVtlDeviceTypeResponse(vtlDeviceARN.map(value => value))
    def vtlDeviceARN: Optional[VTLDeviceARN]
    def getVtlDeviceARN: ZIO[Any, AwsError, VTLDeviceARN] =
      AwsError.unwrapOptionField("vtlDeviceARN", vtlDeviceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeResponse
  ) extends zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse.ReadOnly {
    override val vtlDeviceARN: Optional[VTLDeviceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.vtlDeviceARN())
      .map(value => zio.aws.storagegateway.model.primitives.VTLDeviceARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeResponse
  ): zio.aws.storagegateway.model.UpdateVtlDeviceTypeResponse.ReadOnly =
    new Wrapper(impl)
}
