package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileSystemAssociationARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFileSystemAssociationResponse(
    fileSystemAssociationARN: Optional[FileSystemAssociationARN] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse = {
    import UpdateFileSystemAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse
      .builder()
      .optionallyWith(
        fileSystemAssociationARN.map(value =>
          FileSystemAssociationARN.unwrap(value): java.lang.String
        )
      )(_.fileSystemAssociationARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse
      .wrap(buildAwsValue())
}
object UpdateFileSystemAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse =
      zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse(
        fileSystemAssociationARN.map(value => value)
      )
    def fileSystemAssociationARN: Optional[FileSystemAssociationARN]
    def getFileSystemAssociationARN
        : ZIO[Any, AwsError, FileSystemAssociationARN] = AwsError
      .unwrapOptionField("fileSystemAssociationARN", fileSystemAssociationARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse
  ) extends zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly {
    override val fileSystemAssociationARN: Optional[FileSystemAssociationARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemAssociationARN())
        .map(value =>
          zio.aws.storagegateway.model.primitives
            .FileSystemAssociationARN(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse
  ): zio.aws.storagegateway.model.UpdateFileSystemAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
