package zio.aws.storagegateway.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{Time, GatewayARN}
import scala.jdk.CollectionConverters.*
final case class DescribeAvailabilityMonitorTestResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    status: Optional[
      zio.aws.storagegateway.model.AvailabilityMonitorTestStatus
    ] = Optional.Absent,
    startTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestResponse = {
    import DescribeAvailabilityMonitorTestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Time.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse
      .wrap(buildAwsValue())
}
object DescribeAvailabilityMonitorTestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse =
      zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse(
        gatewayARN.map(value => value),
        status.map(value => value),
        startTime.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def status
        : Optional[zio.aws.storagegateway.model.AvailabilityMonitorTestStatus]
    def startTime: Optional[Time]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.storagegateway.model.AvailabilityMonitorTestStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestResponse
  ) extends zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val status
        : Optional[zio.aws.storagegateway.model.AvailabilityMonitorTestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.storagegateway.model.AvailabilityMonitorTestStatus.wrap(value)
        )
    override val startTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.storagegateway.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestResponse
  ): zio.aws.storagegateway.model.DescribeAvailabilityMonitorTestResponse.ReadOnly =
    new Wrapper(impl)
}
