package zio.aws.storagegateway.model
import scala.jdk.CollectionConverters.*
sealed trait FileShareType {
  def unwrap: software.amazon.awssdk.services.storagegateway.model.FileShareType
}
object FileShareType {
  def wrap(
      value: software.amazon.awssdk.services.storagegateway.model.FileShareType
  ): zio.aws.storagegateway.model.FileShareType = value match {
    case software.amazon.awssdk.services.storagegateway.model.FileShareType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.storagegateway.model.FileShareType.NFS =>
      val r = NFS
      r
    case software.amazon.awssdk.services.storagegateway.model.FileShareType.SMB =>
      val r = SMB
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.storagegateway.model.FileShareType {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.FileShareType =
      software.amazon.awssdk.services.storagegateway.model.FileShareType.UNKNOWN_TO_SDK_VERSION
  }
  case object NFS extends zio.aws.storagegateway.model.FileShareType {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.FileShareType =
      software.amazon.awssdk.services.storagegateway.model.FileShareType.NFS
  }
  case object SMB extends zio.aws.storagegateway.model.FileShareType {
    override def unwrap
        : software.amazon.awssdk.services.storagegateway.model.FileShareType =
      software.amazon.awssdk.services.storagegateway.model.FileShareType.SMB
  }
}
