package zio.aws.storagegateway.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.storagegateway.model.primitives.{
  HourOfDay,
  DayOfWeek,
  GatewayARN,
  GatewayTimezone,
  MinuteOfHour,
  DayOfMonth
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeMaintenanceStartTimeResponse(
    gatewayARN: Optional[GatewayARN] = Optional.Absent,
    hourOfDay: Optional[HourOfDay] = Optional.Absent,
    minuteOfHour: Optional[MinuteOfHour] = Optional.Absent,
    dayOfWeek: Optional[DayOfWeek] = Optional.Absent,
    dayOfMonth: Optional[DayOfMonth] = Optional.Absent,
    timezone: Optional[GatewayTimezone] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeResponse = {
    import DescribeMaintenanceStartTimeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .optionallyWith(hourOfDay.map(value => HourOfDay.unwrap(value): Integer))(
        _.hourOfDay
      )
      .optionallyWith(
        minuteOfHour.map(value => MinuteOfHour.unwrap(value): Integer)
      )(_.minuteOfHour)
      .optionallyWith(dayOfWeek.map(value => DayOfWeek.unwrap(value): Integer))(
        _.dayOfWeek
      )
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): Integer)
      )(_.dayOfMonth)
      .optionallyWith(
        timezone.map(value => GatewayTimezone.unwrap(value): java.lang.String)
      )(_.timezone)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse
      .wrap(buildAwsValue())
}
object DescribeMaintenanceStartTimeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse =
      zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse(
        gatewayARN.map(value => value),
        hourOfDay.map(value => value),
        minuteOfHour.map(value => value),
        dayOfWeek.map(value => value),
        dayOfMonth.map(value => value),
        timezone.map(value => value)
      )
    def gatewayARN: Optional[GatewayARN]
    def hourOfDay: Optional[HourOfDay]
    def minuteOfHour: Optional[MinuteOfHour]
    def dayOfWeek: Optional[DayOfWeek]
    def dayOfMonth: Optional[DayOfMonth]
    def timezone: Optional[GatewayTimezone]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
    def getHourOfDay: ZIO[Any, AwsError, HourOfDay] =
      AwsError.unwrapOptionField("hourOfDay", hourOfDay)
    def getMinuteOfHour: ZIO[Any, AwsError, MinuteOfHour] =
      AwsError.unwrapOptionField("minuteOfHour", minuteOfHour)
    def getDayOfWeek: ZIO[Any, AwsError, DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
    def getTimezone: ZIO[Any, AwsError, GatewayTimezone] =
      AwsError.unwrapOptionField("timezone", timezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeResponse
  ) extends zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse.ReadOnly {
    override val gatewayARN: Optional[GatewayARN] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
    override val hourOfDay: Optional[HourOfDay] = zio.aws.core.internal
      .optionalFromNullable(impl.hourOfDay())
      .map(value => zio.aws.storagegateway.model.primitives.HourOfDay(value))
    override val minuteOfHour: Optional[MinuteOfHour] = zio.aws.core.internal
      .optionalFromNullable(impl.minuteOfHour())
      .map(value => zio.aws.storagegateway.model.primitives.MinuteOfHour(value))
    override val dayOfWeek: Optional[DayOfWeek] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfWeek())
      .map(value => zio.aws.storagegateway.model.primitives.DayOfWeek(value))
    override val dayOfMonth: Optional[DayOfMonth] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfMonth())
      .map(value => zio.aws.storagegateway.model.primitives.DayOfMonth(value))
    override val timezone: Optional[GatewayTimezone] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value =>
        zio.aws.storagegateway.model.primitives.GatewayTimezone(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeResponse
  ): zio.aws.storagegateway.model.DescribeMaintenanceStartTimeResponse.ReadOnly =
    new Wrapper(impl)
}
