package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.VolumeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DetachVolumeRequest(
    volumeARN: VolumeARN,
    forceDetach: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DetachVolumeRequest = {
    import DetachVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DetachVolumeRequest
      .builder()
      .volumeARN(VolumeARN.unwrap(volumeARN): java.lang.String)
      .optionallyWith(forceDetach.map(value => value: java.lang.Boolean))(
        _.forceDetach
      )
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.DetachVolumeRequest.ReadOnly =
    zio.aws.storagegateway.model.DetachVolumeRequest.wrap(buildAwsValue())
}
object DetachVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DetachVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DetachVolumeRequest =
      zio.aws.storagegateway.model
        .DetachVolumeRequest(volumeARN, forceDetach.map(value => value))
    def volumeARN: VolumeARN
    def forceDetach: Optional[Boolean]
    def getVolumeARN: ZIO[Any, Nothing, VolumeARN] = ZIO.succeed(volumeARN)
    def getForceDetach: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDetach", forceDetach)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DetachVolumeRequest
  ) extends zio.aws.storagegateway.model.DetachVolumeRequest.ReadOnly {
    override val volumeARN: VolumeARN =
      zio.aws.storagegateway.model.primitives.VolumeARN(impl.volumeARN())
    override val forceDetach: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDetach())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DetachVolumeRequest
  ): zio.aws.storagegateway.model.DetachVolumeRequest.ReadOnly = new Wrapper(
    impl
  )
}
