package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.TapeARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CancelArchivalResponse(
    tapeARN: Optional[TapeARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CancelArchivalResponse = {
    import CancelArchivalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CancelArchivalResponse
      .builder()
      .optionallyWith(
        tapeARN.map(value => TapeARN.unwrap(value): java.lang.String)
      )(_.tapeARN)
      .build()
  }
  def asReadOnly: zio.aws.storagegateway.model.CancelArchivalResponse.ReadOnly =
    zio.aws.storagegateway.model.CancelArchivalResponse.wrap(buildAwsValue())
}
object CancelArchivalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CancelArchivalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.CancelArchivalResponse =
      zio.aws.storagegateway.model
        .CancelArchivalResponse(tapeARN.map(value => value))
    def tapeARN: Optional[TapeARN]
    def getTapeARN: ZIO[Any, AwsError, TapeARN] =
      AwsError.unwrapOptionField("tapeARN", tapeARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CancelArchivalResponse
  ) extends zio.aws.storagegateway.model.CancelArchivalResponse.ReadOnly {
    override val tapeARN: Optional[TapeARN] = zio.aws.core.internal
      .optionalFromNullable(impl.tapeARN())
      .map(value => zio.aws.storagegateway.model.primitives.TapeARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CancelArchivalResponse
  ): zio.aws.storagegateway.model.CancelArchivalResponse.ReadOnly = new Wrapper(
    impl
  )
}
