package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.ResourceARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AddTagsToResourceResponse(
    resourceARN: Optional[ResourceARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceResponse = {
    import AddTagsToResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceResponse
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.AddTagsToResourceResponse.ReadOnly =
    zio.aws.storagegateway.model.AddTagsToResourceResponse.wrap(buildAwsValue())
}
object AddTagsToResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.AddTagsToResourceResponse =
      zio.aws.storagegateway.model
        .AddTagsToResourceResponse(resourceARN.map(value => value))
    def resourceARN: Optional[ResourceARN]
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceResponse
  ) extends zio.aws.storagegateway.model.AddTagsToResourceResponse.ReadOnly {
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.storagegateway.model.primitives.ResourceARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceResponse
  ): zio.aws.storagegateway.model.AddTagsToResourceResponse.ReadOnly =
    new Wrapper(impl)
}
