package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.GatewayARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateSmbLocalGroupsResponse(
    gatewayARN: Option[GatewayARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsResponse = {
    import UpdateSmbLocalGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsResponse
      .builder()
      .optionallyWith(
        gatewayARN.map(value => GatewayARN.unwrap(value): java.lang.String)
      )(_.gatewayARN)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse.ReadOnly =
    zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse
      .wrap(buildAwsValue())
}
object UpdateSmbLocalGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse =
      zio.aws.storagegateway.model
        .UpdateSmbLocalGroupsResponse(gatewayARN.map(value => value))
    def gatewayARN: Option[GatewayARN]
    def getGatewayARN: ZIO[Any, AwsError, GatewayARN] =
      AwsError.unwrapOptionField("gatewayARN", gatewayARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsResponse
  ) extends zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse.ReadOnly {
    override val gatewayARN: Option[GatewayARN] = scala
      .Option(impl.gatewayARN())
      .map(value => zio.aws.storagegateway.model.primitives.GatewayARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsResponse
  ): zio.aws.storagegateway.model.UpdateSmbLocalGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
